local AtlasLoot = _G.AtlasLoot
local Recipe = {}
AtlasLoot.Data.Recipe = Recipe
local Profession = AtlasLoot.Data.Profession
local AL = AtlasLoot.Locales

local format = string.format
local pairs = _G.pairs


local LOC_STRING = AL["|cff00ff00Left-Click:|r %s"]
local LOC_STRING2 = AL["|cff00ff00Left-Click:|r Show reagents."]
local RECIPE_PROF_DEFAULT = 0
local RECIPE_PROF_TEXT = Profession.PROFESSION_TEXT

local RECIPE = {
	-- [itemID] = { profession, profRank, creationSpell }
	[728] = {6,75,2543}, -- Recipe: Westfall Stew
	[1251] = {1,1,746}, -- Linen Bandage
	[2263] = {5,100,0}, -- Phytoblade
	[2404] = {3,30,2156}, -- Deprecated Pattern: Light Winter Cloak
	[2405] = {3,35,2157}, -- Deprecated Pattern: Light Winter Boots
	[2406] = {3,90,2158}, -- Pattern: Fine Leather Boots
	[2407] = {3,60,2163}, -- Pattern: White Leather Jerkin
	[2408] = {3,75,2164}, -- Pattern: Fine Leather Gloves
	[2409] = {3,100,2169}, -- Pattern: Dark Leather Tunic
	[2553] = {4,50,3230}, -- Recipe: Elixir of Minor Agility
	[2554] = {4,50,2334}, -- Deprecated Recipe: Elixir of Fortitude
	[2555] = {4,60,2335}, -- Recipe: Swiftness Potion
	[2556] = {4,70,2336}, -- Recipe: Elixir of Tongues
	[2581] = {1,20,1159}, -- Heavy Linen Bandage
	[2598] = {8,40,2389}, -- Pattern: Red Linen Robe
	[2599] = {3,45,2409}, -- Deprecated Pattern: Forest Silk Gloves
	[2600] = {3,45,2410}, -- Deprecated Pattern: Trogg Vest
	[2601] = {8,105,2403}, -- Pattern: Gray Woolen Robe
	[2602] = {3,100,2412}, -- Deprecated Pattern: Feathered Robe
	[2697] = {6,50,2542}, -- Recipe: Goretusk Liver Pie
	[2698] = {6,85,2545}, -- Recipe: Cooked Crab Claw
	[2699] = {6,100,2547}, -- Recipe: Redridge Goulash
	[2700] = {6,110,2548}, -- Recipe: Succulent Pork Ribs
	[2701] = {6,100,2549}, -- Recipe: Seasoned Wolf Kabob
	[2881] = {2,80,2667}, -- Plans: Runed Copper Breastplate
	[2882] = {2,125,3330}, -- Plans: Silvered Bronze Shoulders
	[2883] = {2,125,3295}, -- Plans: Deadly Bronze Poniard
	[2889] = {6,25,2795}, -- Recipe: Beer Basted Boar Ribs
	[2895] = {13,100,0}, -- Creeping Pain
	[2896] = {13,150,2826}, -- Creeping Anguish
	[2927] = {13,190,2827}, -- Creeping Torment
	[3393] = {4,110,3172}, -- Recipe: Minor Magic Resistance Potion
	[3394] = {4,120,3174}, -- Recipe: Elixir of Poison Resistance
	[3395] = {4,250,3175}, -- Recipe: Limited Invulnerability Potion
	[3396] = {4,140,2333}, -- Recipe: Elixir of Lesser Agility
	[3530] = {1,50,3267}, -- Wool Bandage
	[3531] = {1,75,3268}, -- Heavy Wool Bandage
	[3608] = {2,145,3297}, -- Plans: Mighty Iron Hammer
	[3609] = {2,35,3321}, -- Plans: Copper Chain Vest
	[3610] = {2,60,3325}, -- Plans: Gemmed Copper Gauntlets
	[3611] = {2,145,3334}, -- Plans: Green Iron Boots
	[3612] = {2,150,3336}, -- Plans: Green Iron Gauntlets
	[3678] = {6,80,3370}, -- Recipe: Crocolisk Steak
	[3679] = {6,60,3371}, -- Recipe: Blood Sausage
	[3680] = {6,90,3372}, -- Recipe: Murloc Fin Soup
	[3681] = {6,120,3373}, -- Recipe: Crocolisk Gumbo
	[3682] = {6,130,3376}, -- Recipe: Curiously Tasty Omelet
	[3683] = {6,110,3377}, -- Recipe: Gooey Spider Cake
	[3734] = {6,110,3397}, -- Recipe: Big Bear Steak
	[3735] = {6,125,3398}, -- Recipe: Hot Lion Chops
	[3736] = {6,150,3399}, -- Recipe: Tasty Lion Steak
	[3737] = {6,175,3400}, -- Recipe: Soothing Turtle Bisque
	[3830] = {4,175,3450}, -- Recipe: Elixir of Fortitude
	[3831] = {4,180,3451}, -- Recipe: Mighty Troll's Blood Potion
	[3832] = {4,195,3453}, -- Recipe: Elixir of Detect Lesser Invisibility
	[3866] = {2,175,3493}, -- Plans: Jade Serpentblade
	[3867] = {2,170,3495}, -- Plans: Golden Iron Destroyer
	[3868] = {2,200,3497}, -- Plans: Frost Tiger Blade
	[3869] = {2,200,3500}, -- Plans: Shadow Crescent Axe
	[3870] = {2,160,3504}, -- Plans: Green Iron Shoulders
	[3871] = {2,175,3505}, -- Plans: Golden Scale Shoulders
	[3872] = {2,170,3507}, -- Plans: Golden Scale Leggings
	[3873] = {2,195,3511}, -- Plans: Golden Scale Cuirass
	[3874] = {2,185,3513}, -- Plans: Polished Steel Boots
	[3875] = {2,200,3515}, -- Plans: Golden Scale Boots
	[4292] = {8,95,3758}, -- Pattern: Green Woolen Bag
	[4293] = {3,100,3762}, -- Pattern: Hillman's Leather Vest
	[4294] = {3,120,3767}, -- Pattern: Hillman's Belt
	[4295] = {3,125,7153}, -- Pattern: Double-stitched Leather Gloves OLD
	[4296] = {3,140,3769}, -- Pattern: Dark Leather Shoulders
	[4297] = {3,150,3771}, -- Pattern: Barbaric Gloves
	[4298] = {3,170,3775}, -- Pattern: Guardian Belt
	[4299] = {3,175,3773}, -- Pattern: Guardian Armor
	[4300] = {3,195,3777}, -- Pattern: Guardian Leather Bracers
	[4301] = {3,200,3779}, -- Pattern: Barbaric Belt
	[4345] = {8,95,3847}, -- Pattern: Red Woolen Boots
	[4346] = {8,100,3844}, -- Pattern: Heavy Woolen Cloak
	[4347] = {8,120,3849}, -- Pattern: Reinforced Woolen Shoulders
	[4348] = {8,125,3868}, -- Pattern: Phoenix Gloves
	[4349] = {8,125,3851}, -- Pattern: Phoenix Pants
	[4350] = {8,140,3856}, -- Pattern: Spider Silk Slippers
	[4351] = {8,170,3858}, -- Pattern: Shadow Hood
	[4352] = {8,175,3860}, -- Pattern: Boots of the Enchanter
	[4353] = {8,180,3863}, -- Pattern: Spider Belt
	[4354] = {8,185,3872}, -- Pattern: Rich Purple Silk Shirt
	[4355] = {8,200,3862}, -- Pattern: Icy Cloak
	[4356] = {8,200,3864}, -- Pattern: Star Belt
	[4358] = {9,1,4054}, -- Rough Dynamite
	[4360] = {9,30,4064}, -- Rough Copper Bomb
	[4365] = {9,75,4061}, -- Coarse Dynamite
	[4366] = {9,85,4071}, -- Target Dummy
	[4367] = {9,100,4056}, -- Small Seaforium Charge
	[4368] = {9,100,0}, -- Flying Tiger Goggles
	[4370] = {9,105,4065}, -- Large Copper Bomb
	[4373] = {9,120,0}, -- Shadow Goggles
	[4374] = {9,120,4066}, -- Small Bronze Bomb
	[4378] = {9,125,4062}, -- Heavy Dynamite
	[4380] = {9,140,4067}, -- Big Bronze Bomb
	[4381] = {9,140,18805}, -- Minor Recombobulator
	[4384] = {9,150,4074}, -- Explosive Sheep
	[4385] = {9,150,0}, -- Green Tinted Goggles
	[4390] = {9,175,4068}, -- Iron Grenade
	[4391] = {9,175,4078}, -- Compact Harvest Reaper Kit
	[4392] = {9,185,4072}, -- Advanced Target Dummy
	[4393] = {9,185,0}, -- Craftsman's Monocle
	[4394] = {9,190,4069}, -- Big Iron Bomb
	[4395] = {9,195,4100}, -- Goblin Land Mine
	[4396] = {9,200,23076}, -- Mechanical Dragonling
	[4397] = {9,200,4079}, -- Gnomish Cloaking Device
	[4398] = {9,200,4075}, -- Large Seaforium Charge
	[4403] = {9,165,4067}, -- Portable Bronze Mortar
	[4408] = {9,75,3928}, -- Schematic: Mechanical Squirrel
	[4409] = {9,100,3933}, -- Schematic: Small Seaforium Charge
	[4410] = {9,120,3940}, -- Schematic: Shadow Goggles
	[4411] = {9,125,3944}, -- Schematic: Flame Deflector
	[4412] = {9,145,3954}, -- Schematic: Moonsight Rifle
	[4413] = {9,160,3959}, -- Schematic: Discombobulator Ray
	[4414] = {9,165,3960}, -- Schematic: Portable Bronze Mortar
	[4415] = {9,185,3966}, -- Schematic: Craftsman's Monocle
	[4416] = {9,195,3968}, -- Schematic: Goblin Land Mine
	[4417] = {9,200,3972}, -- Schematic: Large Seaforium Charge
	[4548] = {9,100,0}, -- Servomechanic Sledgehammer
	[4597] = {4,50,4508}, -- Recipe: Discolored Healing Potion
	[4609] = {6,175,4094}, -- Recipe: Barbecued Buzzard Wing
	[4624] = {4,215,4942}, -- Recipe: Lesser Stoneshield Potion
	[4997] = {6,110,0}, -- Deprecated Recipe: Kodo Skin Bag
	[5083] = {3,40,5244}, -- Pattern: Kodo Hide Bag
	[5482] = {6,10,6412}, -- Recipe: Kaldorei Spider Kabob
	[5483] = {6,20,6413}, -- Recipe: Scorpid Surprise
	[5484] = {6,35,6414}, -- Recipe: Roasted Kodo Meat
	[5485] = {6,50,6415}, -- Recipe: Fillet of Frenzy
	[5486] = {6,50,6416}, -- Recipe: Strider Stew
	[5487] = {6,90,6417}, -- Recipe: Dig Rat Stew
	[5488] = {6,100,6418}, -- Recipe: Crispy Lizard Tail
	[5489] = {6,110,6419}, -- Recipe: Lean Venison
	[5528] = {6,90,6501}, -- Recipe: Clam Chowder
	[5543] = {2,140,6518}, -- Plans: Iridescent Hammer
	[5577] = {2,100,2671}, -- Plans: Rough Bronze Bracers
	[5578] = {2,130,2673}, -- Plans: Silvered Bronze Breastplate
	[5640] = {4,60,6617}, -- Recipe: Rage Potion
	[5641] = {4,125,6619}, -- Recipe: Cowardly Flight Potion
	[5642] = {4,150,6624}, -- Recipe: Free Action Potion
	[5643] = {4,175,6618}, -- Recipe: Great Rage Potion
	[5654] = {13,0,6650}, -- Instant Toxin
	[5657] = {13,120,6651}, -- Recipe: Instant Toxin
	[5771] = {8,70,6686}, -- Pattern: Red Linen Bag
	[5772] = {8,115,6688}, -- Pattern: Red Woolen Bag
	[5773] = {8,150,6692}, -- Pattern: Robes of Arcana
	[5774] = {8,175,6693}, -- Pattern: Green Silk Pack
	[5775] = {8,185,6695}, -- Pattern: Black Silk Pack
	[5786] = {3,90,6702}, -- Pattern: Murloc Scale Belt
	[5787] = {3,95,6703}, -- Pattern: Murloc Scale Breastplate
	[5788] = {3,170,6704}, -- Pattern: Thick Murloc Armor
	[5789] = {3,190,6705}, -- Pattern: Murloc Scale Bracers
	[5972] = {3,105,7133}, -- Pattern: Fine Leather Pants
	[5973] = {3,170,7149}, -- Pattern: Barbaric Leggings
	[5974] = {3,185,7153}, -- Pattern: Guardian Cloak
	[6039] = {6,175,7213}, -- Recipe: Giant Clam Scorcho
	[6041] = {2,190,7220}, -- Steel Weapon Chain
	[6042] = {2,150,7216}, -- Iron Shield Spike
	[6043] = {2,165,7218}, -- Iron Counterweight
	[6044] = {2,150,7221}, -- Plans: Iron Shield Spike
	[6045] = {2,165,7222}, -- Plans: Iron Counterweight
	[6046] = {2,190,7224}, -- Plans: Steel Weapon Chain
	[6047] = {2,190,3503}, -- Plans: Golden Scale Coif
	[6053] = {4,100,7255}, -- Recipe: Holy Protection Potion
	[6054] = {4,135,7256}, -- Recipe: Shadow Protection Potion
	[6055] = {4,165,7257}, -- Recipe: Fire Protection Potion
	[6056] = {4,190,7258}, -- Recipe: Frost Protection Potion
	[6057] = {4,190,7259}, -- Recipe: Nature Protection Potion
	[6068] = {4,165,3449}, -- Recipe: Shadow Oil
	[6211] = {4,150,3188}, -- Recipe: Elixir of Ogre's Strength
	[6219] = {9,50,0}, -- Arclight Spanner
	[6222] = {10,60,7451}, -- Formula: Imbue Chest - Minor Spirit
	[6270] = {8,55,7630}, -- Pattern: Blue Linen Vest
	[6271] = {8,55,7629}, -- Pattern: Red Linen Vest
	[6272] = {8,70,7633}, -- Pattern: Blue Linen Robe
	[6273] = {8,90,7636}, -- Pattern: Green Woolen Robe
	[6274] = {8,100,7639}, -- Pattern: Blue Overalls
	[6275] = {8,115,7643}, -- Pattern: Greater Adept's Robe
	[6325] = {6,1,7751}, -- Recipe: Brilliant Smallfish
	[6326] = {6,1,7752}, -- Recipe: Slitherskin Mackerel
	[6328] = {6,50,7753}, -- Recipe: Longjaw Mud Snapper
	[6329] = {6,50,7754}, -- Recipe: Loch Frenzy Delight
	[6330] = {6,100,7755}, -- Recipe: Bristle Whisker Catfish
	[6342] = {10,20,7443}, -- Formula: Enchant Chest - Minor Mana
	[6343] = {10,60,7451}, -- Formula: Imbue Chest - Spirit
	[6344] = {10,60,7766}, -- Formula: Enchant Bracer - Minor Spirit
	[6345] = {10,90,7771}, -- Formula: Imbue Cloak - Protection
	[6346] = {10,80,7776}, -- Formula: Enchant Chest - Lesser Mana
	[6347] = {10,80,7782}, -- Formula: Enchant Bracer - Minor Strength
	[6348] = {10,90,7786}, -- Formula: Enchant Weapon - Minor Beastslayer
	[6349] = {10,100,7793}, -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6365] = {11,10,0}, -- Strong Fishing Pole
	[6366] = {11,50,0}, -- Darkwood Fishing Pole
	[6367] = {11,100,0}, -- Big Iron Fishing Pole
	[6368] = {6,50,7827}, -- Recipe: Rainbow Fin Albacore
	[6369] = {6,175,7828}, -- Recipe: Rockscale Cod
	[6375] = {10,120,7859}, -- Formula: Enchant Bracer - Lesser Spirit
	[6376] = {10,125,7863}, -- Formula: Enchant Boots - Minor Stamina
	[6377] = {10,125,7867}, -- Formula: Enchant Boots - Minor Agility
	[6390] = {8,120,7892}, -- Pattern: Stylish Blue Shirt
	[6391] = {8,120,7893}, -- Pattern: Stylish Green Shirt
	[6401] = {8,155,3870}, -- Pattern: Dark Silk Shirt
	[6450] = {1,100,7926}, -- Silk Bandage
	[6451] = {1,125,7927}, -- Heavy Silk Bandage
	[6454] = {1,130,7935}, -- Manual: Strong Anti-Venom
	[6474] = {3,90,7953}, -- Pattern: Deviate Scale Cloak
	[6475] = {3,105,7954}, -- Pattern: Deviate Scale Gloves
	[6476] = {3,115,7955}, -- Pattern: Deviate Scale Belt
	[6530] = {11,50,8088}, -- Nightcrawlers
	[6532] = {11,100,8090}, -- Bright Baubles
	[6533] = {11,100,8089}, -- Aquadynamic Fish Attractor
	[6661] = {6,85,8238}, -- Recipe: Savory Deviate Delight
	[6663] = {4,90,8240}, -- Recipe: Elixir of Giant Growth
	[6672] = {9,185,8243}, -- Schematic: Flash Bomb
	[6710] = {3,90,8322}, -- Pattern: Moonglow Vest
	[6716] = {9,100,8339}, -- Schematic: EZ-Thro Dynamite
	[6734] = {2,70,8366}, -- Plans: Ironforge Chain
	[6735] = {2,100,8367}, -- Plans: Ironforge Breastplate
	[6736] = {2,140,8368}, -- Plans: Ironforge Gauntlets
	[6811] = {11,50,8532}, -- Aquadynamic Fish Lens
	[6891] = {6,1,8604}, -- Recipe: Herb Baked Egg
	[6892] = {6,40,8607}, -- Recipe: Smoked Bear Meat
	[7084] = {8,190,8793}, -- Pattern: Crimson Silk Shoulders
	[7085] = {8,190,8795}, -- Pattern: Azure Shoulders
	[7086] = {8,195,8797}, -- Pattern: Earthen Silk Belt
	[7087] = {8,180,8789}, -- Pattern: Crimson Silk Cloak
	[7088] = {8,205,8802}, -- Pattern: Crimson Silk Robe
	[7089] = {8,175,8786}, -- Pattern: Azure Silk Cloak
	[7090] = {8,165,8784}, -- Pattern: Green Silk Armor
	[7091] = {8,150,8782}, -- Pattern: Truefaith Gloves
	[7092] = {8,145,8780}, -- Pattern: Hands of Darkness
	[7093] = {8,140,8778}, -- Pattern: Boots of Darkness
	[7114] = {8,145,3854}, -- Pattern: Azure Silk Gloves
	[7148] = {9,165,8342}, -- Goblin Jumper Cables
	[7192] = {9,130,8895}, -- Schematic: Goblin Rocket Boots
	[7288] = {3,35,9064}, -- Pattern: Rugged Leather Pants
	[7289] = {3,100,9070}, -- Pattern: Black Whelp Cloak
	[7290] = {3,120,9072}, -- Pattern: Red Whelp Gloves
	[7307] = {11,100,9092}, -- Flesh Eating Worm
	[7360] = {3,120,3765}, -- Pattern: Dark Leather Gloves
	[7361] = {3,135,9146}, -- Pattern: Herbalist's Gloves
	[7362] = {3,135,9147}, -- Pattern: Earthen Leather Shoulders
	[7363] = {3,140,9148}, -- Pattern: Pilferer's Gloves
	[7364] = {3,145,9149}, -- Pattern: Heavy Earthen Gloves
	[7449] = {3,165,9195}, -- Pattern: Dusky Leather Leggings
	[7450] = {3,175,9197}, -- Pattern: Green Whelp Armor
	[7451] = {3,190,9202}, -- Pattern: Green Whelp Bracers
	[7452] = {3,200,9207}, -- Pattern: Dusky Boots
	[7453] = {3,200,9208}, -- Pattern: Swift Boots
	[7506] = {9,125,8344}, -- Gnomish Universal Remote
	[7560] = {9,125,9269}, -- Schematic: Gnomish Universal Remote
	[7561] = {9,165,9273}, -- Schematic: Goblin Jumper Cables
	[7613] = {3,155,3772}, -- Pattern: Green Leather Armor
	[7678] = {6,60,9513}, -- Recipe: Thistle Tea
	[7742] = {9,200,3971}, -- Schematic: Gnomish Cloaking Device
	[7967] = {2,215,9781}, -- Mithril Shield Spike
	[7969] = {2,215,9783}, -- Mithril Spurs
	[7975] = {2,210,9933}, -- Plans: Heavy Mithril Pants
	[7976] = {2,215,9939}, -- Plans: Mithril Shield Spike
	[7977] = {2,220,9942}, -- Plans: Mithril Scale Gloves
	[7978] = {2,160,9811}, -- Plans: Barbaric Iron Shoulders
	[7979] = {2,160,9813}, -- Plans: Barbaric Iron Breastplate
	[7980] = {2,175,9814}, -- Plans: Barbaric Iron Helm
	[7981] = {2,180,9818}, -- Plans: Barbaric Iron Boots
	[7982] = {2,185,9820}, -- Plans: Barbaric Iron Gloves
	[7983] = {2,220,9945}, -- Plans: Ornate Mithril Pants
	[7984] = {2,220,9950}, -- Plans: Ornate Mithril Gloves
	[7985] = {2,225,9952}, -- Plans: Ornate Mithril Shoulder
	[7986] = {2,240,9972}, -- Plans: Ornate Mithril Breastplate
	[7987] = {2,245,9980}, -- Plans: Ornate Mithril Helm
	[7988] = {2,245,9979}, -- Plans: Ornate Mithril Boots
	[7989] = {2,235,9964}, -- Plans: Mithril Spurs
	[7990] = {2,245,9970}, -- Plans: Heavy Mithril Helm
	[7991] = {2,235,9966}, -- Plans: Mithril Scale Shoulders
	[7992] = {2,220,9995}, -- Plans: Blue Glittering Axe
	[7993] = {2,240,10005}, -- Plans: Dazzling Mithril Rapier
	[7994] = {2,230,9957}, -- Plans: Orcish War Leggings
	[7995] = {2,215,9937}, -- Plans: Mithril Scale Bracers
	[7996] = {11,1,0}, -- Worn Fishing Hat
	[8028] = {2,245,10009}, -- Plans: Runed Mithril Hammer
	[8029] = {2,225,9997}, -- Plans: Wicked Mithril Blade
	[8030] = {2,255,10013}, -- Plans: Ebon Shiv
	[8384] = {3,200,10490}, -- Pattern: Comfortable Leather Hat
	[8385] = {3,205,10509}, -- Pattern: Turtle Scale Gloves
	[8386] = {3,215,10520}, -- Pattern: Big Voodoo Robe
	[8387] = {3,220,10531}, -- Pattern: Big Voodoo Mask
	[8388] = {3,230,10550}, -- Pattern: Nightscape Cloak
	[8389] = {3,240,10560}, -- Pattern: Big Voodoo Pants
	[8390] = {3,240,10562}, -- Pattern: Big Voodoo Cloak
	[8395] = {3,220,10525}, -- Pattern: Tough Scorpid Breastplate
	[8397] = {3,220,10533}, -- Pattern: Tough Scorpid Bracers
	[8398] = {3,225,10542}, -- Pattern: Tough Scorpid Gloves
	[8399] = {3,235,10554}, -- Pattern: Tough Scorpid Boots
	[8400] = {3,240,10564}, -- Pattern: Tough Scorpid Shoulders
	[8401] = {3,245,10568}, -- Pattern: Tough Scorpid Leggings
	[8402] = {3,250,10570}, -- Pattern: Tough Scorpid Helm
	[8403] = {3,220,10529}, -- Pattern: Wild Leather Shoulders
	[8404] = {3,225,10544}, -- Pattern: Wild Leather Vest
	[8405] = {3,225,10546}, -- Pattern: Wild Leather Helmet
	[8406] = {3,245,10566}, -- Pattern: Wild Leather Boots
	[8407] = {3,250,10572}, -- Pattern: Wild Leather Leggings
	[8408] = {3,250,10574}, -- Pattern: Wild Leather Cloak
	[8409] = {3,210,10516}, -- Pattern: Nightscape Shoulders
	[8544] = {1,150,10838}, -- Mageweave Bandage
	[8545] = {1,175,10839}, -- Heavy Mageweave Bandage
	[8546] = {1,200,10850}, -- Powerful Smelling Salts
	[8547] = {1,250,10844}, -- Formula: Powerful Smelling Salts
	[8663] = {2,210,0}, -- Mithril Insignia
	[8703] = {2,210,11209}, -- Signet of Expertise
	[9293] = {4,210,11453}, -- Recipe: Magic Resistance Potion
	[9294] = {4,225,11458}, -- Recipe: Wildvine Potion
	[9295] = {4,235,11464}, -- Recipe: Invisibility Potion
	[9296] = {4,240,11466}, -- Recipe: Gift of Arthas
	[9297] = {4,240,11468}, -- Recipe: Elixir of Dream Vision
	[9298] = {4,245,11472}, -- Recipe: Elixir of Giants
	[9300] = {4,250,11477}, -- Recipe: Elixir of Demonslaying
	[9301] = {4,250,11476}, -- Recipe: Elixir of Shadow Power
	[9302] = {4,245,11473}, -- Recipe: Ghost Dye
	[9303] = {4,225,11459}, -- Recipe: Philosopher's Stone
	[9304] = {4,225,11479}, -- Recipe: Transmute Iron to Gold
	[9305] = {4,225,11480}, -- Recipe: Transmute Mithril to Truesilver
	[9327] = {9,1,0}, -- Security DELTA Data Access Card
	[9367] = {2,205,11643}, -- Plans: Golden Scale Gauntlets
	[9465] = {7,175,0}, -- Digmaster 5000
	[9508] = {9,75,0}, -- Mechbuilder's Overalls
	[9719] = {2,190,11923}, -- Broken Blade of Heroes
	[10300] = {8,215,12056}, -- Pattern: Red Mageweave Vest
	[10301] = {8,215,12059}, -- Pattern: White Bandit Mask
	[10302] = {8,215,12060}, -- Pattern: Red Mageweave Pants
	[10303] = {8,220,12062}, -- Pattern: Stormcloth Pants
	[10304] = {8,220,12063}, -- Pattern: Stormcloth Gloves
	[10311] = {8,220,12064}, -- Pattern: Orange Martial Shirt
	[10312] = {8,225,12066}, -- Pattern: Red Mageweave Gloves
	[10313] = {8,225,12068}, -- Pattern: Stormcloth Vest
	[10314] = {8,230,12075}, -- Pattern: Lavender Mageweave Shirt
	[10315] = {8,235,12078}, -- Pattern: Red Mageweave Shoulders
	[10316] = {8,120,12047}, -- Pattern: Colorful Kilt
	[10317] = {8,235,12080}, -- Pattern: Pink Mageweave Shirt
	[10318] = {8,240,12081}, -- Pattern: Admiral's Hat
	[10319] = {8,240,12083}, -- Pattern: Stormcloth Headband
	[10320] = {8,240,12084}, -- Pattern: Red Mageweave Headband
	[10321] = {8,240,12085}, -- Pattern: Tuxedo Shirt
	[10322] = {8,245,12087}, -- Pattern: Stormcloth Shoulders
	[10323] = {8,245,12089}, -- Pattern: Tuxedo Pants
	[10324] = {8,250,12090}, -- Pattern: Stormcloth Boots
	[10325] = {8,250,12091}, -- Pattern: White Wedding Dress
	[10326] = {8,250,12093}, -- Pattern: Tuxedo Jacket
	[10418] = {2,225,12733}, -- Glimmering Mithril Insignia
	[10424] = {2,155,12259}, -- Plans: Silvered Bronze Leggings
	[10463] = {8,245,12086}, -- Pattern: Shadoweave Mask
	[10499] = {9,175,0}, -- Bright-Eye Goggles
	[10500] = {9,205,0}, -- Fire Goggles
	[10501] = {9,220,0}, -- Catseye Ultra Goggles
	[10502] = {9,215,0}, -- Spellpower Goggles Xtreme
	[10503] = {9,230,0}, -- Rose Colored Goggles
	[10504] = {9,245,0}, -- Green Lens
	[10506] = {9,230,0}, -- Deepdive Helmet
	[10507] = {9,175,12419}, -- Solid Dynamite
	[10514] = {9,205,12421}, -- Mithril Frag Bomb
	[10518] = {9,225,12438}, -- Parachute Cloak
	[10542] = {9,205,0}, -- Goblin Mining Helmet
	[10543] = {9,205,12561}, -- Goblin Construction Helmet
	[10545] = {9,210,0}, -- Gnomish Goggles
	[10562] = {9,235,12543}, -- Hi-Explosive Bomb
	[10576] = {9,250,23075}, -- Mithril Mechanical Dragonling
	[10577] = {9,205,13237}, -- Goblin Mortar
	[10586] = {9,225,12562}, -- The Big One
	[10587] = {9,230,23134}, -- Goblin Bomb Dispenser
	[10588] = {9,235,22641}, -- Goblin Rocket Helmet
	[10596] = {9,230,0}, -- Deprecated Rose Colored Goggles
	[10601] = {9,175,12587}, -- Schematic: Bright-Eye Goggles
	[10602] = {9,210,12597}, -- Schematic: Deadly Scope
	[10603] = {9,220,12607}, -- Schematic: Catseye Ultra Goggles
	[10604] = {9,220,12614}, -- Schematic: Mithril Heavy-bore Rifle
	[10605] = {9,225,12615}, -- Schematic: Spellpower Goggles Xtreme
	[10606] = {9,225,12616}, -- Schematic: Parachute Cloak
	[10607] = {9,230,12617}, -- Schematic: Deepdive Helmet
	[10608] = {9,240,12620}, -- Schematic: Sniper Scope
	[10609] = {9,250,12624}, -- Schematic: Mithril Mechanical Dragonling
	[10644] = {4,210,11456}, -- Recipe: Goblin Rocket Fuel
	[10646] = {9,205,13241}, -- Goblin Sapper Charge
	[10713] = {2,200,11454}, -- Plans: Inlaid Mithril Cylinder
	[10716] = {9,205,13006}, -- Gnomish Shrink Ray
	[10719] = {9,205,4074}, -- Mobile Alarm
	[10720] = {9,210,13120}, -- Gnomish Net-o-Matic Projector
	[10721] = {9,215,13234}, -- Gnomish Harm Prevention Belt
	[10724] = {9,225,13141}, -- Gnomish Rocket Boots
	[10725] = {9,230,23133}, -- Gnomish Battle Chicken
	[10726] = {9,215,13180}, -- Gnomish Mind Control Cap
	[10728] = {8,200,3873}, -- Pattern: Black Swashbuckler's Shirt
	[10858] = {2,155,3494}, -- Plans: Solid Iron Maul
	[11038] = {10,110,13380}, -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039] = {10,110,13419}, -- Formula: Enchant Cloak - Minor Agility
	[11081] = {10,115,13464}, -- Formula: Enchant Shield - Lesser Protection
	[11098] = {10,135,13522}, -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101] = {10,140,13536}, -- Formula: Enchant Bracer - Lesser Strength
	[11150] = {10,145,13612}, -- Formula: Enchant Gloves - Mining
	[11151] = {10,145,13617}, -- Formula: Enchant Gloves - Herbalism
	[11152] = {10,145,13620}, -- Formula: Enchant Gloves - Fishing
	[11163] = {10,170,13646}, -- Formula: Enchant Bracer - Lesser Deflection
	[11164] = {10,175,13653}, -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165] = {10,175,13655}, -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[11166] = {10,200,13698}, -- Formula: Enchant Gloves - Skinning
	[11167] = {10,190,13687}, -- Formula: Enchant Boots - Lesser Spirit
	[11168] = {10,195,13689}, -- Formula: Enchant Shield - Lesser Block
	[11202] = {10,210,13817}, -- Formula: Enchant Shield - Stamina
	[11203] = {10,215,13841}, -- Formula: Enchant Gloves - Advanced Mining
	[11204] = {10,220,13846}, -- Formula: Enchant Bracer - Greater Spirit
	[11205] = {10,225,13868}, -- Formula: Enchant Gloves - Advanced Herbalism
	[11206] = {10,225,13882}, -- Formula: Enchant Cloak - Lesser Agility
	[11207] = {10,265,13898}, -- Formula: Enchant Weapon - Fiery Weapon
	[11208] = {10,230,13915}, -- Formula: Enchant Weapon - Demonslaying
	[11223] = {10,235,13931}, -- Formula: Enchant Bracer - Deflection
	[11224] = {10,235,13933}, -- Formula: Enchant Shield - Frost Resistance
	[11225] = {10,245,13945}, -- Formula: Enchant Bracer - Greater Stamina
	[11226] = {10,250,13947}, -- Formula: Enchant Gloves - Riding Skill
	[11590] = {9,200,15057}, -- Mechanical Repair Kit
	[11610] = {2,265,15292}, -- Plans: Dark Iron Pulverizer
	[11611] = {2,275,15294}, -- Plans: Dark Iron Sunderer
	[11612] = {2,285,15296}, -- Plans: Dark Iron Plate
	[11614] = {2,270,15293}, -- Plans: Dark Iron Mail
	[11615] = {2,280,15295}, -- Plans: Dark Iron Shoulders
	[11813] = {10,265,15596}, -- Formula: Smoking Heart of the Mountain
	[11827] = {9,205,15633}, -- Schematic: Lil' Smoky
	[11828] = {9,205,15628}, -- Schematic: Pet Bombling
	[12162] = {2,160,3492}, -- Plans: Hardened Iron Shortsword
	[12163] = {2,180,3496}, -- Plans: Moonsteel Broadsword
	[12164] = {2,185,3498}, -- Plans: Massive Iron Axe
	[12225] = {11,1,0}, -- Blump Family Fishing Pole
	[12226] = {6,1,15935}, -- Recipe: Crispy Bat Wing
	[12227] = {6,125,15853}, -- Recipe: Lean Wolf Steak
	[12228] = {6,175,15855}, -- Recipe: Roast Raptor
	[12229] = {6,175,15856}, -- Recipe: Hot Wolf Ribs
	[12231] = {6,175,15861}, -- Recipe: Jungle Stew
	[12232] = {6,175,15863}, -- Recipe: Carrion Surprise
	[12233] = {6,175,15865}, -- Recipe: Mystery Stew
	[12239] = {6,200,15906}, -- Recipe: Dragonbreath Chili
	[12240] = {6,200,15910}, -- Recipe: Heavy Kodo Stew
	[12261] = {2,190,15973}, -- Plans: Searing Golden Blade
	[12645] = {2,250,16623}, -- Thorium Shield Spike
	[12682] = {2,250,16642}, -- Plans: Thorium Armor
	[12683] = {2,250,16643}, -- Plans: Thorium Belt
	[12684] = {2,255,16644}, -- Plans: Thorium Bracers
	[12685] = {2,260,16645}, -- Plans: Radiant Belt
	[12687] = {2,265,16646}, -- Plans: Imperial Plate Shoulders
	[12688] = {2,265,16647}, -- Plans: Imperial Plate Belt
	[12689] = {2,270,16648}, -- Plans: Radiant Breastplate
	[12690] = {2,270,16649}, -- Plans: Imperial Plate Bracers
	[12691] = {2,270,16650}, -- Plans: Wildthorn Mail
	[12692] = {2,275,16651}, -- Plans: Thorium Shield Spike
	[12693] = {2,280,16652}, -- Plans: Thorium Boots
	[12694] = {2,280,16653}, -- Plans: Thorium Helm
	[12695] = {2,285,16654}, -- Plans: Radiant Gloves
	[12696] = {2,285,16667}, -- Plans: Demon Forged Breastplate
	[12697] = {2,290,16656}, -- Plans: Radiant Boots
	[12698] = {2,290,16660}, -- Plans: Dawnbringer Shoulders
	[12699] = {2,290,16655}, -- Plans: Fiery Plate Gauntlets
	[12700] = {2,295,16657}, -- Plans: Imperial Plate Boots
	[12701] = {2,295,16658}, -- Plans: Imperial Plate Helm
	[12702] = {2,295,16659}, -- Plans: Radiant Circlet
	[12703] = {2,295,16661}, -- Plans: Storm Gauntlets
	[12704] = {2,300,16662}, -- Plans: Thorium Leggings
	[12705] = {2,300,16663}, -- Plans: Imperial Plate Chest
	[12706] = {2,300,16664}, -- Plans: Runic Plate Shoulders
	[12707] = {2,300,16665}, -- Plans: Runic Plate Boots
	[12711] = {2,300,16724}, -- Plans: Whitesoul Helm
	[12713] = {2,300,16725}, -- Plans: Radiant Leggings
	[12714] = {2,300,16726}, -- Plans: Runic Plate Helm
	[12715] = {2,300,16730}, -- Plans: Imperial Plate Leggings
	[12716] = {2,300,16728}, -- Plans: Helm of the Great Chief
	[12717] = {2,300,16729}, -- Plans: Lionheart Helm
	[12718] = {2,300,16731}, -- Plans: Runic Breastplate
	[12719] = {2,300,16732}, -- Plans: Runic Plate Leggings
	[12720] = {2,300,16741}, -- Plans: Stronghold Gauntlets
	[12725] = {2,300,16742}, -- Plans: Enchanted Thorium Helm
	[12726] = {2,300,16744}, -- Plans: Enchanted Thorium Leggings
	[12727] = {2,300,16745}, -- Plans: Enchanted Thorium Breastplate
	[12728] = {2,300,16746}, -- Plans: Invulnerable Mail
	[12816] = {2,260,16960}, -- Plans: Thorium Greatsword
	[12817] = {2,270,16965}, -- Plans: Bleakwood Hew
	[12818] = {2,270,16967}, -- Plans: Inlaid Thorium Hammer
	[12819] = {2,275,16969}, -- Plans: Ornate Thorium Handaxe
	[12821] = {2,275,16970}, -- Plans: Dawn's Edge
	[12823] = {2,280,16971}, -- Plans: Huge Thorium Battleaxe
	[12824] = {2,280,16973}, -- Plans: Enchanted Battlehammer
	[12825] = {2,280,16978}, -- Plans: Blazing Rapier
	[12826] = {2,285,16980}, -- Plans: Rune Edge
	[12827] = {2,285,16983}, -- Plans: Serenity
	[12828] = {2,290,16984}, -- Plans: Volcanic Hammer
	[12830] = {2,290,16985}, -- Plans: Corruption
	[12831] = {2,300,16986}, -- Plans: Blood Talon
	[12832] = {2,300,16987}, -- Plans: Darkspear
	[12833] = {2,300,16988}, -- Plans: Hammer of the Titans
	[12834] = {2,300,16990}, -- Plans: Arcanite Champion
	[12835] = {2,300,16991}, -- Plans: Annihilator
	[12836] = {2,300,16992}, -- Plans: Frostguard
	[12837] = {2,300,16993}, -- Plans: Masterwork Stormhammer
	[12838] = {2,300,16994}, -- Plans: Arcanite Reaper
	[12839] = {2,300,16995}, -- Plans: Heartseeker
	[12958] = {4,275,17187}, -- Recipe: Transmute Arcanite
	[13287] = {3,165,4096}, -- Pattern: Raptor Hide Harness
	[13288] = {3,165,4097}, -- Pattern: Raptor Hide Belt
	[13308] = {9,155,3957}, -- Schematic: Ice Deflector
	[13309] = {9,120,3939}, -- Schematic: Lovingly Crafted Boomstick
	[13310] = {9,180,3979}, -- Schematic: Accurate Scope
	[13311] = {9,200,3969}, -- Schematic: Mechanical Dragonling
	[13476] = {4,255,17552}, -- Recipe: Mighty Rage Potion
	[13477] = {4,260,17553}, -- Recipe: Superior Mana Potion
	[13478] = {4,265,17554}, -- Recipe: Elixir of Superior Defense
	[13479] = {4,270,17555}, -- Recipe: Elixir of the Sages
	[13480] = {4,275,17556}, -- Recipe: Major Healing Potion
	[13481] = {4,275,17557}, -- Recipe: Elixir of Brute Force
	[13482] = {4,275,17559}, -- Recipe: Transmute Air to Fire
	[13483] = {4,275,17560}, -- Recipe: Transmute Fire to Earth
	[13484] = {4,275,17561}, -- Recipe: Transmute Earth to Water
	[13485] = {4,275,17562}, -- Recipe: Transmute Water to Air
	[13486] = {4,275,17563}, -- Recipe: Transmute Undeath to Water
	[13487] = {4,275,17564}, -- Recipe: Transmute Water to Undeath
	[13488] = {4,275,17565}, -- Recipe: Transmute Life to Earth
	[13489] = {4,275,17566}, -- Recipe: Transmute Earth to Life
	[13490] = {4,280,17570}, -- Recipe: Greater Stoneshield Potion
	[13491] = {4,280,17571}, -- Recipe: Elixir of the Mongoose
	[13492] = {4,285,17572}, -- Recipe: Purification Potion
	[13493] = {4,285,17573}, -- Recipe: Greater Arcane Elixir
	[13494] = {4,290,17574}, -- Recipe: Greater Fire Protection Potion
	[13495] = {4,290,17575}, -- Recipe: Greater Frost Protection Potion
	[13496] = {4,290,17576}, -- Recipe: Greater Nature Protection Potion
	[13497] = {4,290,17577}, -- Recipe: Greater Arcane Protection Potion
	[13499] = {4,290,17578}, -- Recipe: Greater Shadow Protection Potion
	[13500] = {4,290,17579}, -- Recipe: Greater Holy Protection Potion
	[13501] = {4,295,17580}, -- Recipe: Major Mana Potion
	[13503] = {4,300,0}, -- Alchemists' Stone
	[13517] = {4,300,17632}, -- Recipe: Alchemists' Stone
	[13518] = {4,300,17634}, -- Recipe: Flask of Petrification
	[13519] = {4,300,17635}, -- Recipe: Flask of the Titans
	[13520] = {4,300,17636}, -- Recipe: Flask of Distilled Wisdom
	[13521] = {4,300,17637}, -- Recipe: Flask of Supreme Power
	[13522] = {4,300,17638}, -- Recipe: Flask of Chromatic Resistance
	[13939] = {6,225,18238}, -- Recipe: Spotted Yellowtail
	[13940] = {6,225,18239}, -- Recipe: Cooked Glossy Mightfish
	[13941] = {6,225,18241}, -- Recipe: Filet of Redgill
	[13942] = {6,240,18240}, -- Recipe: Grilled Squid
	[13943] = {6,240,18242}, -- Recipe: Hot Smoked Bass
	[13945] = {6,250,18243}, -- Recipe: Nightfin Soup
	[13946] = {6,250,18244}, -- Recipe: Poached Sunscale Salmon
	[13947] = {6,275,18245}, -- Recipe: Lobster Stew
	[13948] = {6,275,18246}, -- Recipe: Mightfish Steak
	[13949] = {6,275,18247}, -- Recipe: Baked Salmon
	[14466] = {8,255,18403}, -- Pattern: Frostweave Tunic
	[14467] = {8,255,18404}, -- Pattern: Frostweave Robe
	[14468] = {8,260,18405}, -- Pattern: Runecloth Bag
	[14469] = {8,260,18406}, -- Pattern: Runecloth Robe
	[14470] = {8,260,18407}, -- Pattern: Runecloth Tunic
	[14471] = {8,260,18408}, -- Pattern: Cindercloth Vest
	[14472] = {8,265,18409}, -- Pattern: Runecloth Cloak
	[14473] = {8,265,18410}, -- Pattern: Ghostweave Belt
	[14474] = {8,265,18411}, -- Pattern: Frostweave Gloves
	[14476] = {8,270,18412}, -- Pattern: Cindercloth Gloves
	[14477] = {8,270,18413}, -- Pattern: Ghostweave Gloves
	[14478] = {8,270,18414}, -- Pattern: Brightcloth Robe
	[14479] = {8,270,18415}, -- Pattern: Brightcloth Gloves
	[14480] = {8,275,18416}, -- Pattern: Ghostweave Vest
	[14481] = {8,275,18417}, -- Pattern: Runecloth Gloves
	[14482] = {8,275,18418}, -- Pattern: Cindercloth Cloak
	[14483] = {8,275,18419}, -- Pattern: Felcloth Pants
	[14484] = {8,275,18420}, -- Pattern: Brightcloth Cloak
	[14485] = {8,275,18421}, -- Pattern: Wizardweave Leggings
	[14486] = {8,275,18422}, -- Pattern: Cloak of Fire
	[14488] = {8,280,18423}, -- Pattern: Runecloth Boots
	[14489] = {8,280,18424}, -- Pattern: Frostweave Pants
	[14490] = {8,280,18434}, -- Pattern: Cindercloth Pants
	[14491] = {8,285,18438}, -- Pattern: Runecloth Pants
	[14492] = {8,285,18437}, -- Pattern: Felcloth Boots
	[14493] = {8,285,18436}, -- Pattern: Robe of Winter Night
	[14494] = {8,290,18439}, -- Pattern: Brightcloth Pants
	[14495] = {8,290,18441}, -- Pattern: Ghostweave Pants
	[14496] = {8,290,18442}, -- Pattern: Felcloth Hood
	[14497] = {8,290,18440}, -- Pattern: Mooncloth Leggings
	[14498] = {8,295,18444}, -- Pattern: Runecloth Headband
	[14499] = {8,300,18445}, -- Pattern: Mooncloth Bag
	[14500] = {8,300,18446}, -- Pattern: Wizardweave Robe
	[14501] = {8,300,18447}, -- Pattern: Mooncloth Vest
	[14504] = {8,300,18449}, -- Pattern: Runecloth Shoulders
	[14505] = {8,300,18450}, -- Pattern: Wizardweave Turban
	[14506] = {8,300,18451}, -- Pattern: Felcloth Robe
	[14507] = {8,300,18448}, -- Pattern: Mooncloth Shoulders
	[14508] = {8,300,18453}, -- Pattern: Felcloth Shoulders
	[14509] = {8,300,18452}, -- Pattern: Mooncloth Circlet
	[14510] = {8,300,18455}, -- Pattern: Bottomless Bag
	[14511] = {8,300,18454}, -- Pattern: Gloves of Spell Mastery
	[14512] = {8,300,18456}, -- Pattern: Truefaith Vestments
	[14513] = {8,300,18457}, -- Pattern: Robe of the Archmage
	[14514] = {8,300,18458}, -- Pattern: Robe of the Void
	[14526] = {8,250,18560}, -- Pattern: Mooncloth
	[14529] = {1,200,18608}, -- Runecloth Bandage
	[14530] = {1,225,18610}, -- Heavy Runecloth Bandage
	[14627] = {8,135,3869}, -- Pattern: Bright Yellow Shirt
	[14630] = {8,165,3857}, -- Pattern: Enchanter's Cowl
	[14634] = {4,200,3454}, -- Recipe: Frost Oil
	[14635] = {3,185,3778}, -- Pattern: Gem-studded Leather Belt
	[14639] = {9,140,3952}, -- Schematic: Minor Recombobulator
	[15724] = {3,255,19048}, -- Pattern: Heavy Scorpid Bracers
	[15725] = {3,260,19049}, -- Pattern: Wicked Leather Gauntlets
	[15726] = {3,260,19050}, -- Pattern: Green Dragonscale Breastplate
	[15727] = {3,265,19051}, -- Pattern: Heavy Scorpid Vest
	[15728] = {3,265,19052}, -- Pattern: Wicked Leather Bracers
	[15729] = {3,265,19053}, -- Pattern: Chimeric Gloves
	[15730] = {3,300,19054}, -- Pattern: Red Dragonscale Breastplate
	[15731] = {3,270,19055}, -- Pattern: Runic Leather Gauntlets
	[15732] = {3,270,19059}, -- Pattern: Volcanic Leggings
	[15733] = {3,270,19060}, -- Pattern: Green Dragonscale Leggings
	[15734] = {3,270,19061}, -- Pattern: Living Shoulders
	[15735] = {3,270,19062}, -- Pattern: Ironfeather Shoulders
	[15737] = {3,275,19063}, -- Pattern: Chimeric Boots
	[15738] = {3,275,19064}, -- Pattern: Heavy Scorpid Gauntlets
	[15739] = {3,275,19065}, -- Pattern: Runic Leather Bracers
	[15740] = {3,275,19066}, -- Pattern: Frostsaber Boots
	[15741] = {3,275,19067}, -- Pattern: Stormshroud Pants
	[15742] = {3,275,19068}, -- Pattern: Warbear Harness
	[15743] = {3,280,19070}, -- Pattern: Heavy Scorpid Belt
	[15744] = {3,280,19071}, -- Pattern: Wicked Leather Headband
	[15745] = {3,280,19072}, -- Pattern: Runic Leather Belt
	[15746] = {3,280,19073}, -- Pattern: Chimeric Leggings
	[15747] = {3,285,19074}, -- Pattern: Frostsaber Leggings
	[15748] = {3,285,19075}, -- Pattern: Heavy Scorpid Leggings
	[15749] = {3,285,19076}, -- Pattern: Volcanic Breastplate
	[15751] = {3,285,19077}, -- Pattern: Blue Dragonscale Breastplate
	[15752] = {3,285,19078}, -- Pattern: Living Leggings
	[15753] = {3,285,19079}, -- Pattern: Stormshroud Armor
	[15754] = {3,285,19080}, -- Pattern: Warbear Woolies
	[15755] = {3,290,19081}, -- Pattern: Chimeric Vest
	[15756] = {3,290,19082}, -- Pattern: Runic Leather Headband
	[15757] = {3,290,19083}, -- Pattern: Wicked Leather Pants
	[15758] = {3,290,19084}, -- Pattern: Devilsaur Gauntlets
	[15759] = {3,290,19085}, -- Pattern: Black Dragonscale Breastplate
	[15760] = {3,290,19086}, -- Pattern: Ironfeather Breastplate
	[15761] = {3,295,19087}, -- Pattern: Frostsaber Gloves
	[15762] = {3,295,19088}, -- Pattern: Heavy Scorpid Helm
	[15763] = {3,295,19089}, -- Pattern: Blue Dragonscale Shoulders
	[15764] = {3,295,19090}, -- Pattern: Stormshroud Shoulders
	[15765] = {3,300,19091}, -- Pattern: Runic Leather Pants
	[15768] = {3,300,19092}, -- Pattern: Wicked Leather Belt
	[15769] = {3,300,19093}, -- Pattern: Onyxia Scale Cloak
	[15770] = {3,300,19094}, -- Pattern: Black Dragonscale Shoulders
	[15771] = {3,300,19095}, -- Pattern: Living Breastplate
	[15772] = {3,300,19097}, -- Pattern: Devilsaur Leggings
	[15773] = {3,300,19098}, -- Pattern: Wicked Leather Armor
	[15774] = {3,300,19100}, -- Pattern: Heavy Scorpid Shoulders
	[15775] = {3,300,19101}, -- Pattern: Volcanic Shoulders
	[15776] = {3,300,19102}, -- Pattern: Runic Leather Armor
	[15777] = {3,300,19103}, -- Pattern: Runic Leather Shoulders
	[15779] = {3,300,19104}, -- Pattern: Frostsaber Tunic
	[15780] = {3,300,19106}, -- Pattern: Onyxia Scale Breastplate
	[15781] = {3,300,19107}, -- Pattern: Black Dragonscale Leggings
	[15846] = {3,250,19566}, -- Salt Shaker
	[15869] = {2,100,19646}, -- Silver Skeleton Key
	[15870] = {2,150,19649}, -- Golden Skeleton Key
	[15871] = {2,200,19651}, -- Truesilver Skeleton Key
	[15872] = {2,275,20709}, -- Arcanite Skeleton Key
	[15993] = {9,260,19769}, -- Thorium Grenade
	[15999] = {9,270,0}, -- Spellpower Goggles Xtreme Plus
	[16005] = {9,285,19784}, -- Dark Iron Bomb
	[16008] = {9,280,0}, -- Master Engineer's Goggles
	[16022] = {9,300,23074}, -- Arcanite Dragonling
	[16023] = {9,275,19805}, -- Masterwork Target Dummy
	[16040] = {9,300,19821}, -- Arcane Bomb
	[16041] = {9,260,19790}, -- Schematic: Thorium Grenade
	[16042] = {9,260,19791}, -- Schematic: Thorium Widget
	[16043] = {9,260,19792}, -- Schematic: Thorium Rifle
	[16044] = {9,265,19793}, -- Schematic: Lifelike Mechanical Toad
	[16045] = {9,270,19794}, -- Schematic: Spellpower Goggles Xtreme Plus
	[16046] = {9,275,19814}, -- Schematic: Masterwork Target Dummy
	[16047] = {9,275,19795}, -- Schematic: Thorium Tube
	[16048] = {9,275,19796}, -- Schematic: Dark Iron Rifle
	[16049] = {9,285,19799}, -- Schematic: Dark Iron Bomb
	[16050] = {9,285,19815}, -- Schematic: Delicate Arcanite Converter
	[16051] = {9,285,19800}, -- Schematic: Thorium Shells
	[16052] = {9,290,19819}, -- Schematic: Voice Amplification Modulator
	[16053] = {9,290,19825}, -- Schematic: Master Engineer's Goggles
	[16054] = {9,300,19830}, -- Schematic: Arcanite Dragonling
	[16055] = {9,300,19831}, -- Schematic: Arcane Bomb
	[16056] = {9,300,19833}, -- Schematic: Flawless Arcanite Rifle
	[16072] = {6,125,3413}, -- Expert Cookbook
	[16073] = {6,200,18260}, -- Artisan Cookbook
	[16082] = {11,200,18248}, -- Artisan Fishing - The Way of the Lure
	[16083] = {11,125,7732}, -- Expert Fishing - The Bass and You
	[16084] = {1,125,7924}, -- Expert First Aid - Under Wraps
	[16085] = {1,200,10846}, -- Artisan First Aid - Heal Thyself
	[16110] = {6,225,15933}, -- Recipe: Monster Omelet
	[16111] = {6,225,15915}, -- Recipe: Spiced Chili Crab
	[16112] = {1,180,7929}, -- Manual: Heavy Silk Bandage
	[16113] = {1,210,10840}, -- Manual: Mageweave Bandage
	[16214] = {10,255,20008}, -- Formula: Enchant Bracer - Greater Intellect
	[16215] = {10,260,20020}, -- Formula: Enchant Boots - Greater Stamina
	[16216] = {10,265,20014}, -- Formula: Enchant Cloak - Greater Resistance
	[16217] = {10,265,20017}, -- Formula: Enchant Shield - Greater Stamina
	[16218] = {10,270,20009}, -- Formula: Enchant Bracer - Superior Spirit
	[16219] = {10,270,20012}, -- Formula: Enchant Gloves - Greater Agility
	[16220] = {10,275,20024}, -- Formula: Enchant Boots - Spirit
	[16221] = {10,275,20026}, -- Formula: Enchant Chest - Major Health
	[16222] = {10,280,20016}, -- Formula: Enchant Shield - Superior Spirit
	[16223] = {10,285,20029}, -- Formula: Enchant Weapon - Icy Chill
	[16224] = {10,285,20015}, -- Formula: Enchant Cloak - Superior Defense
	[16242] = {10,290,20028}, -- Formula: Enchant Chest - Major Mana
	[16243] = {10,290,20051}, -- Formula: Runed Arcanite Rod
	[16244] = {10,295,20013}, -- Formula: Enchant Gloves - Greater Strength
	[16245] = {10,295,20023}, -- Formula: Enchant Boots - Greater Agility
	[16246] = {10,295,20010}, -- Formula: Enchant Bracer - Superior Strength
	[16247] = {10,295,20030}, -- Formula: Enchant 2H Weapon - Superior Impact
	[16248] = {10,295,20033}, -- Formula: Enchant Weapon - Unholy
	[16249] = {10,300,20036}, -- Formula: Enchant 2H Weapon - Major Intellect
	[16250] = {10,300,20031}, -- Formula: Enchant Weapon - Superior Striking
	[16251] = {10,300,20011}, -- Formula: Enchant Bracer - Superior Stamina
	[16252] = {10,300,20034}, -- Formula: Enchant Weapon - Crusader
	[16253] = {10,300,20025}, -- Formula: Enchant Chest - Greater Stats
	[16254] = {10,300,20032}, -- Formula: Enchant Weapon - Lifestealing
	[16255] = {10,300,20035}, -- Formula: Enchant 2H Weapon - Major Spirit
	[16767] = {6,225,20626}, -- Recipe: Undermine Clam Chowder
	[17017] = {8,300,20848}, -- Pattern: Flarecore Mantle
	[17018] = {8,300,20849}, -- Pattern: Flarecore Gloves
	[17022] = {3,295,20853}, -- Pattern: Corehound Boots
	[17023] = {3,300,20854}, -- Pattern: Molten Helm
	[17025] = {3,300,20855}, -- Pattern: Black Dragonscale Boots
	[17049] = {2,295,20872}, -- Plans: Fiery Chain Girdle
	[17051] = {2,295,20874}, -- Plans: Dark Iron Bracers
	[17052] = {2,300,20876}, -- Plans: Dark Iron Leggings
	[17053] = {2,300,20873}, -- Plans: Fiery Chain Shoulders
	[17059] = {2,300,20890}, -- Plans: Dark Iron Reaver
	[17060] = {2,300,20897}, -- Plans: Dark Iron Destroyer
	[17062] = {6,175,20916}, -- Recipe: Mithril Head Trout
	[17200] = {6,1,21143}, -- Recipe: Gingerbread Cookie
	[17201] = {6,35,21144}, -- Recipe: Egg Nog
	[17706] = {2,190,21913}, -- Plans: Edge of Winter
	[17709] = {4,190,21923}, -- Recipe: Elixir of Frost Power
	[17716] = {9,190,21935}, -- SnowMaster 9000
	[17720] = {9,190,21940}, -- Schematic: Snowmaster 9000
	[17722] = {3,190,21943}, -- Pattern: Gloves of the Greatfather
	[17724] = {8,190,21945}, -- Pattern: Green Holiday Shirt
	[17725] = {10,190,21931}, -- Formula: Enchant Weapon - Winter's Might
	[18046] = {6,225,22480}, -- Recipe: Tender Wolf Steak
	[18160] = {6,60,9513}, -- Recipe: Thistle Tea
	[18168] = {9,300,0}, -- Force Reactive Disk
	[18232] = {9,300,22700}, -- Field Repair Bot 74A
	[18235] = {9,300,22704}, -- Schematic: Field Repair Bot 74A
	[18239] = {3,200,22711}, -- Pattern: Shadowskin Gloves
	[18252] = {3,300,22727}, -- Pattern: Core Armor Kit
	[18257] = {4,300,22732}, -- Recipe: Major Rejuvenation Potion
	[18259] = {10,300,22749}, -- Formula: Enchant Weapon - Spell Power
	[18260] = {10,300,22750}, -- Formula: Enchant Weapon - Healing Power
	[18264] = {2,300,22757}, -- Plans: Elemental Sharpening Stone
	[18265] = {8,300,22759}, -- Pattern: Flarecore Wraps
	[18267] = {6,275,22761}, -- Recipe: Runn Tum Tuber Surprise
	[18290] = {9,300,22793}, -- Schematic: Biznicks 247x128 Accurascope
	[18291] = {9,300,22797}, -- Schematic: Force Reactive Disk
	[18292] = {9,300,22795}, -- Schematic: Core Marksman Rifle
	[18414] = {8,300,22866}, -- Pattern: Belt of the Archmage
	[18415] = {8,300,22867}, -- Pattern: Felcloth Gloves
	[18416] = {8,300,22868}, -- Pattern: Inferno Gloves
	[18417] = {8,300,22869}, -- Pattern: Mooncloth Gloves
	[18418] = {8,300,22870}, -- Pattern: Cloak of Warding
	[18487] = {8,300,22902}, -- Pattern: Mooncloth Robe
	[18514] = {3,300,22921}, -- Pattern: Girdle of Insight
	[18515] = {3,300,22922}, -- Pattern: Mongoose Boots
	[18516] = {3,300,22923}, -- Pattern: Swift Flight Bracers
	[18517] = {3,300,22926}, -- Pattern: Chromatic Cloak
	[18518] = {3,300,22927}, -- Pattern: Hide of the Wild
	[18519] = {3,300,22928}, -- Pattern: Shifting Cloak
	[18587] = {9,265,22999}, -- Goblin Jumper Cables XL
	[18592] = {2,300,21161}, -- Plans: Sulfuron Hammer
	[18594] = {9,275,23008}, -- Powerful Seaforium Charge
	[18634] = {9,260,23131}, -- Gyrofreeze Ice Reflector
	[18637] = {9,275,23064}, -- Major Recombobulator
	[18638] = {9,290,23097}, -- Hyper-Radiant Flame Reflector
	[18639] = {9,300,23132}, -- Ultra-Flash Shadow Reflector
	[18641] = {9,250,23063}, -- Dense Dynamite
	[18645] = {9,265,23004}, -- Gnomish Alarm-O-Bot
	[18647] = {9,150,23066}, -- Schematic: Red Firework
	[18648] = {9,150,23068}, -- Schematic: Green Firework
	[18649] = {9,150,23067}, -- Schematic: Blue Firework
	[18650] = {9,200,23069}, -- Schematic: EZ-Thro Dynamite II
	[18651] = {9,260,23071}, -- Schematic: Truesilver Transformer
	[18652] = {9,260,23077}, -- Schematic: Gyrofreeze Ice Reflector
	[18653] = {9,265,23078}, -- Schematic: Goblin Jumper Cables XL
	[18654] = {9,265,23096}, -- Schematic: Gnomish Alarm-O-Bot
	[18655] = {9,275,23079}, -- Schematic: Major Recombobulator
	[18656] = {9,275,23080}, -- Schematic: Powerful Seaforium Charge
	[18657] = {9,290,23081}, -- Schematic: Hyper-Radiant Flame Reflector
	[18658] = {9,300,23082}, -- Schematic: Ultra-Flash Shadow Reflector
	[18660] = {9,250,23126}, -- World Enlarger
	[18661] = {9,260,23129}, -- Schematic: World Enlarger
	[18731] = {3,150,23190}, -- Pattern: Heavy Leather Ball
	[18769] = {2,300,0}, -- Enchanted Thorium Platemail
	[18770] = {2,300,0}, -- Enchanted Thorium Platemail
	[18771] = {2,300,0}, -- Enchanted Thorium Platemail
	[18949] = {3,155,23399}, -- Pattern: Barbaric Bracers
	[18984] = {9,260,23442}, -- Dimensional Ripper - Everlook
	[18986] = {9,260,23453}, -- Ultrasafe Transporter: Gadgetzan
	[19022] = {11,100,0}, -- Nat Pagle's Extreme Angler FC-5000
	[19027] = {9,250,23507}, -- Schematic: Snake Burst Firework
	[19066] = {1,225,23567}, -- Warsong Gulch Runecloth Bandage
	[19067] = {1,175,23568}, -- Warsong Gulch Mageweave Bandage
	[19068] = {1,125,23569}, -- Warsong Gulch Silk Bandage
	[19202] = {2,290,23628}, -- Plans: Heavy Timbermaw Belt
	[19203] = {2,290,23632}, -- Plans: Girdle of the Dawn
	[19204] = {2,300,23629}, -- Plans: Heavy Timbermaw Boots
	[19205] = {2,300,23633}, -- Plans: Gloves of the Dawn
	[19206] = {2,300,23636}, -- Plans: Dark Iron Helm
	[19207] = {2,300,23637}, -- Plans: Dark Iron Gauntlets
	[19208] = {2,300,23638}, -- Plans: Black Amnesty
	[19209] = {2,300,23639}, -- Plans: Blackfury
	[19210] = {2,300,23650}, -- Plans: Ebon Hand
	[19211] = {2,300,23652}, -- Plans: Blackguard
	[19212] = {2,300,23653}, -- Plans: Nightfall
	[19215] = {8,290,23662}, -- Pattern: Wisdom of the Timbermaw
	[19216] = {8,290,23664}, -- Pattern: Argent Boots
	[19217] = {8,300,23665}, -- Pattern: Argent Shoulders
	[19218] = {8,300,23663}, -- Pattern: Mantle of the Timbermaw
	[19219] = {8,300,23666}, -- Pattern: Flarecore Robe
	[19220] = {8,300,23667}, -- Pattern: Flarecore Leggings
	[19307] = {1,225,23696}, -- Alterac Heavy Runecloth Bandage
	[19326] = {3,290,23703}, -- Pattern: Might of the Timbermaw
	[19327] = {3,300,23704}, -- Pattern: Timbermaw Brawlers
	[19328] = {3,290,23705}, -- Pattern: Dawn Treaders
	[19329] = {3,300,23706}, -- Pattern: Golden Mantle of the Dawn
	[19330] = {3,300,23707}, -- Pattern: Lava Belt
	[19331] = {3,300,23708}, -- Pattern: Chromatic Gauntlets
	[19332] = {3,300,23709}, -- Pattern: Corehound Belt
	[19333] = {3,300,23710}, -- Pattern: Molten Belt
	[19440] = {1,300,23786}, -- Powerful Anti-Venom
	[19442] = {1,300,23787}, -- Formula: Powerful Anti-Venom
	[19444] = {10,290,23799}, -- Formula: Enchant Weapon - Strength
	[19445] = {10,290,23800}, -- Formula: Enchant Weapon - Agility
	[19446] = {10,290,23801}, -- Formula: Enchant Bracer - Mana Regeneration
	[19447] = {10,300,23802}, -- Formula: Enchant Bracer - Healing
	[19448] = {10,300,23803}, -- Formula: Enchant Weapon - Mighty Spirit
	[19449] = {10,300,23804}, -- Formula: Enchant Weapon - Mighty Intellect
	[19764] = {8,300,24091}, -- Pattern: Bloodvine Vest
	[19765] = {8,300,24092}, -- Pattern: Bloodvine Leggings
	[19766] = {8,300,24093}, -- Pattern: Bloodvine Boots
	[19769] = {3,300,24121}, -- Pattern: Primal Batskin Jerkin
	[19770] = {3,300,24122}, -- Pattern: Primal Batskin Gloves
	[19771] = {3,300,24123}, -- Pattern: Primal Batskin Bracers
	[19772] = {3,300,24124}, -- Pattern: Blood Tiger Breastplate
	[19773] = {3,300,24125}, -- Pattern: Blood Tiger Shoulders
	[19776] = {2,300,24136}, -- Plans: Bloodsoul Breastplate
	[19777] = {2,300,24137}, -- Plans: Bloodsoul Shoulders
	[19778] = {2,300,24138}, -- Plans: Bloodsoul Gauntlets
	[19779] = {2,300,24139}, -- Plans: Darksoul Breastplate
	[19780] = {2,300,24140}, -- Plans: Darksoul Leggings
	[19781] = {2,300,24141}, -- Plans: Darksoul Shoulders
	[19969] = {11,1,0}, -- Nat Pagle's Extreme Anglin' Boots
	[19970] = {11,300,0}, -- Arcanite Fishing Pole
	[19971] = {11,150,24302}, -- High Test Eternium Fishing Line
	[19972] = {11,1,0}, -- Lucky Fishing Hat
	[19998] = {9,300,0}, -- Bloodvine Lens
	[19999] = {9,300,0}, -- Bloodvine Goggles
	[20000] = {9,300,24356}, -- Schematic: Bloodvine Goggles
	[20001] = {9,300,24357}, -- Schematic: Bloodvine Lens
	[20011] = {4,275,24365}, -- Recipe: Mageblood Potion
	[20012] = {4,275,24366}, -- Recipe: Greater Dreamless Sleep
	[20013] = {4,285,24367}, -- Recipe: Living Action Potion
	[20014] = {4,290,24368}, -- Recipe: Major Troll's Blood Potion
	[20040] = {2,300,24399}, -- Plans: Dark Iron Boots
	[20065] = {1,175,24413}, -- Arathi Basin Mageweave Bandage
	[20066] = {1,225,24414}, -- Arathi Basin Runecloth Bandage
	[20067] = {1,125,24412}, -- Arathi Basin Silk Bandage
	[20075] = {6,150,24418}, -- Recipe: Heavy Crocolisk Stew
	[20232] = {1,175,24413}, -- Defiler's Mageweave Bandage
	[20234] = {1,225,24414}, -- Defiler's Runecloth Bandage
	[20235] = {1,125,24412}, -- Defiler's Silk Bandage
	[20237] = {1,175,24413}, -- Highlander's Mageweave Bandage
	[20243] = {1,225,24414}, -- Highlander's Runecloth Bandage
	[20244] = {1,125,24412}, -- Highlander's Silk Bandage
	[20253] = {3,275,19068}, -- Pattern: Warbear Harness
	[20254] = {3,285,19080}, -- Pattern: Warbear Woolies
	[20382] = {3,300,24703}, -- Pattern: Dreamscale Breastplate
	[20506] = {3,300,24846}, -- Pattern: Spitfire Bracers
	[20507] = {3,300,24847}, -- Pattern: Spitfire Gauntlets
	[20508] = {3,300,24848}, -- Pattern: Spitfire Breastplate
	[20509] = {3,300,24849}, -- Pattern: Sandstalker Bracers
	[20510] = {3,300,24850}, -- Pattern: Sandstalker Gauntlets
	[20511] = {3,300,24851}, -- Pattern: Sandstalker Breastplate
	[20546] = {8,300,24901}, -- Pattern: Runed Stygian Leggings
	[20547] = {8,300,24903}, -- Pattern: Runed Stygian Boots
	[20548] = {8,300,24902}, -- Pattern: Runed Stygian Belt
	[20553] = {2,300,24912}, -- Plans: Darkrune Gauntlets
	[20554] = {2,300,24914}, -- Plans: Darkrune Breastplate
	[20555] = {2,300,24913}, -- Plans: Darkrune Helm
	[20576] = {3,100,24940}, -- Pattern: Black Whelp Tunic
	[20726] = {10,300,25072}, -- Formula: Enchant Gloves - Threat
	[20727] = {10,300,25073}, -- Formula: Enchant Gloves - Shadow Power
	[20728] = {10,300,25074}, -- Formula: Enchant Gloves - Frost Power
	[20729] = {10,300,25078}, -- Formula: Enchant Gloves - Fire Power
	[20730] = {10,300,25079}, -- Formula: Enchant Gloves - Healing Power
	[20731] = {10,300,25080}, -- Formula: Enchant Gloves - Superior Agility
	[20732] = {10,300,25081}, -- Formula: Enchant Cloak - Greater Fire Resistance
	[20733] = {10,300,25082}, -- Formula: Enchant Cloak - Greater Nature Resistance
	[20734] = {10,300,25083}, -- Formula: Enchant Cloak - Stealth
	[20735] = {10,300,25084}, -- Formula: Enchant Cloak - Subtlety
	[20736] = {10,300,25086}, -- Formula: Enchant Cloak - Dodge
	[20752] = {10,150,25125}, -- Formula: Minor Mana Oil
	[20753] = {10,200,25126}, -- Formula: Lesser Wizard Oil
	[20754] = {10,250,25127}, -- Formula: Lesser Mana Oil
	[20755] = {10,275,25128}, -- Formula: Wizard Oil
	[20756] = {10,300,25129}, -- Formula: Brilliant Wizard Oil
	[20757] = {10,300,25130}, -- Formula: Brilliant Mana Oil
	[20758] = {10,45,25124}, -- Formula: Minor Wizard Oil
	[20761] = {4,300,25146}, -- Recipe: Transmute Elemental Fire
	[21025] = {6,300,25659}, -- Recipe: Dirge's Kickin' Chimaerok Chops
	[21099] = {6,80,25704}, -- Recipe: Smoked Sagefish
	[21219] = {6,175,25954}, -- Recipe: Sagefish Delight
	[21358] = {8,260,26085}, -- Pattern: Soul Pouch
	[21369] = {8,285,26086}, -- Pattern: Felcloth Bag
	[21371] = {8,300,26087}, -- Pattern: Core Felcloth Bag
	[21547] = {4,250,26277}, -- Recipe: Elixir of Greater Firepower
	[21548] = {3,300,26279}, -- Pattern: Stormshroud Gloves
	[21722] = {8,250,26403}, -- Pattern: Festival Dress
	[21723] = {8,250,26407}, -- Pattern: Festival Suit
	[21724] = {9,125,26416}, -- Schematic: Small Blue Rocket
	[21725] = {9,125,26417}, -- Schematic: Small Green Rocket
	[21726] = {9,125,26418}, -- Schematic: Small Red Rocket
	[21727] = {9,175,26420}, -- Schematic: Large Blue Rocket
	[21728] = {9,175,26421}, -- Schematic: Large Green Rocket
	[21729] = {9,175,26422}, -- Schematic: Large Red Rocket
	[21730] = {9,225,26423}, -- Schematic: Blue Rocket Cluster
	[21731] = {9,225,26424}, -- Schematic: Green Rocket Cluster
	[21732] = {9,225,26425}, -- Schematic: Red Rocket Cluster
	[21733] = {9,275,26426}, -- Schematic: Large Blue Rocket Cluster
	[21734] = {9,275,26427}, -- Schematic: Large Green Rocket Cluster
	[21735] = {9,275,26428}, -- Schematic: Large Red Rocket Cluster
	[21737] = {9,275,26443}, -- Schematic: Cluster Launcher
	[21738] = {9,225,26442}, -- Schematic: Firework Launcher
	[22209] = {2,300,27585}, -- Plans: Heavy Obsidian Belt
	[22214] = {2,300,27588}, -- Plans: Light Obsidian Belt
	[22219] = {2,300,27586}, -- Plans: Jagged Obsidian Shield
	[22220] = {2,300,27589}, -- Plans: Black Grasp of the Destroyer
	[22221] = {2,300,27590}, -- Plans: Obsidian Mail Tunic
	[22222] = {2,300,27587}, -- Plans: Thick Obsidian Breastplate
	[22307] = {8,225,27658}, -- Pattern: Enchanted Mageweave Pouch
	[22308] = {8,275,27659}, -- Pattern: Enchanted Runecloth Bag
	[22309] = {8,300,27660}, -- Pattern: Big Bag of Enchantment
	[22310] = {8,275,27724}, -- Pattern: Cenarion Herb Bag
	[22312] = {8,300,27725}, -- Pattern: Satchel of Cenarius
	[22388] = {2,300,27829}, -- Plans: Titanic Leggings
	[22389] = {2,300,27832}, -- Plans: Sageblade
	[22390] = {2,300,27830}, -- Plans: Persuader
	[22392] = {10,290,27837}, -- Formula: Enchant 2H Weapon - Agility
	[22683] = {8,300,28210}, -- Pattern: Gaea's Embrace
	[22684] = {8,300,28205}, -- Pattern: Glacial Gloves
	[22685] = {8,300,28208}, -- Pattern: Glacial Cloak
	[22686] = {8,300,28207}, -- Pattern: Glacial Vest
	[22687] = {8,300,28209}, -- Pattern: Glacial Wrists
	[22692] = {3,300,28219}, -- Pattern: Polar Tunic
	[22694] = {3,300,28220}, -- Pattern: Polar Gloves
	[22695] = {3,300,28221}, -- Pattern: Polar Bracers
	[22696] = {3,300,28222}, -- Pattern: Icy Scale Breastplate
	[22697] = {3,300,28223}, -- Pattern: Icy Scale Gauntlets
	[22698] = {3,300,28224}, -- Pattern: Icy Scale Bracers
	[22703] = {2,300,28242}, -- Plans: Icebane Breastplate
	[22704] = {2,300,28243}, -- Plans: Icebane Gauntlets
	[22705] = {2,300,28244}, -- Plans: Icebane Bracers
	[22729] = {9,275,28327}, -- Schematic: Steam Tonk Controller
	[22766] = {2,300,28461}, -- Plans: Ironvine Breastplate
	[22767] = {2,300,28462}, -- Plans: Ironvine Gloves
	[22768] = {2,300,28463}, -- Plans: Ironvine Belt
	[22769] = {3,300,28474}, -- Pattern: Bramblewood Belt
	[22770] = {3,300,28473}, -- Pattern: Bramblewood Boots
	[22771] = {3,300,28472}, -- Pattern: Bramblewood Helm
	[22772] = {8,300,28482}, -- Pattern: Sylvan Shoulders
	[22773] = {8,300,28481}, -- Pattern: Sylvan Crown
	[22774] = {8,300,28480}, -- Pattern: Sylvan Vest
	[23418] = {9,205,29324}, -- Test Sapper Charge
	[23684] = {1,225,30020}, -- Crystal Infused Bandage
	[23689] = {1,300,30021}, -- Manual: Crystal Infused Bandage
	[23690] = {6,300,30047}, -- Recipe: Crystal Flake Throat Lozenge
--@version-bcc@
	[2770] = {14,1,0}, -- Copper Ore
	[2771] = {14,50,0}, -- Tin Ore
	[2772] = {14,125,0}, -- Iron Ore
	[2889] = {6,10,2795}, -- Recipe: Beer Basted Boar Ribs
	[3394] = {4,120,3174}, -- Recipe: Potion of Curing
	[3858] = {14,175,0}, -- Mithril Ore
	[7189] = {9,225,0}, -- Goblin Rocket Boots
	[9149] = {4,200,0}, -- Philosopher's Stone
	[10620] = {14,250,0}, -- Thorium Ore
	[13503] = {4,350,0}, -- Alchemist's Stone
	[13517] = {4,350,17632}, -- Recipe: Alchemist's Stone
	[17716] = {9,190,0}, -- Snowmaster 9000
	[20012] = {4,275,24366}, -- Recipe: Greater Dreamless Sleep Potion
	[20854] = {14,110,25339}, -- Design: Amulet of the Moon
	[20855] = {14,125,25323}, -- Design: Wicked Moonstone Ring
	[20856] = {14,150,25320}, -- Design: Heavy Golden Necklace of Battle
	[20970] = {14,120,25610}, -- Design: Pendant of the Agate Shield
	[20971] = {14,125,25612}, -- Design: Heavy Iron Knuckles
	[20972] = {14,145,25614}, -- Design: Silver Rose Pendant
	[20973] = {14,150,25617}, -- Design: Blazing Citrine Ring
	[20974] = {14,160,25618}, -- Design: Jade Pendant of Blasting
	[20975] = {14,170,25619}, -- Design: The Jade Eye
	[20976] = {14,190,25622}, -- Design: Citrine Pendant of Golden Healing
	[21892] = {8,325,26747}, -- Pattern: Bolt of Imbued Netherweave
	[21893] = {8,340,26749}, -- Pattern: Imbued Netherweave Bag
	[21894] = {8,345,26750}, -- Pattern: Bolt of Soulcloth
	[21895] = {8,350,26751}, -- Pattern: Primal Mooncloth
	[21896] = {8,340,26773}, -- Pattern: Netherweave Robe
	[21897] = {8,345,26774}, -- Pattern: Netherweave Tunic
	[21898] = {8,340,26775}, -- Pattern: Imbued Netherweave Pants
	[21899] = {8,350,26776}, -- Pattern: Imbued Netherweave Boots
	[21900] = {8,360,26777}, -- Pattern: Imbued Netherweave Robe
	[21901] = {8,360,26778}, -- Pattern: Imbued Netherweave Tunic
	[21902] = {8,355,26779}, -- Pattern: Soulcloth Gloves
	[21903] = {8,365,26780}, -- Pattern: Soulcloth Shoulders
	[21904] = {8,375,26781}, -- Pattern: Soulcloth Vest
	[21905] = {8,350,26782}, -- Pattern: Arcanoweave Bracers
	[21906] = {8,360,26783}, -- Pattern: Arcanoweave Boots
	[21907] = {8,370,26784}, -- Pattern: Arcanoweave Robe
	[21908] = {8,355,26752}, -- Pattern: Spellfire Belt
	[21909] = {8,365,26753}, -- Pattern: Spellfire Gloves
	[21910] = {8,375,26754}, -- Pattern: Spellfire Robe
	[21911] = {8,375,26755}, -- Pattern: Spellfire Bag
	[21912] = {8,355,26756}, -- Pattern: Frozen Shadoweave Shoulders
	[21913] = {8,375,26758}, -- Pattern: Frozen Shadoweave Robe
	[21914] = {8,365,26757}, -- Pattern: Frozen Shadoweave Boots
	[21915] = {8,375,26759}, -- Pattern: Ebon Shadowbag
	[21916] = {8,355,26760}, -- Pattern: Primal Mooncloth Belt
	[21917] = {8,375,26762}, -- Pattern: Primal Mooncloth Robe
	[21918] = {8,365,26761}, -- Pattern: Primal Mooncloth Shoulders
	[21919] = {8,375,26763}, -- Pattern: Primal Mooncloth Bag
	[21924] = {8,260,18406}, -- Pattern: Runecloth Robe
	[21940] = {14,200,26873}, -- Design: Golden Hare
	[21941] = {14,215,26875}, -- Design: Black Pearl Panther
	[21942] = {14,225,26878}, -- Design: Ruby Crown of Restoration
	[21943] = {14,225,26881}, -- Design: Truesilver Crab
	[21944] = {14,235,26882}, -- Design: Truesilver Boar
	[21945] = {14,245,26887}, -- Design: The Aquamarine Ward
	[21947] = {14,250,26896}, -- Design: Gem Studded Band
	[21948] = {14,250,26897}, -- Design: Opal Necklace of Impact
	[21949] = {14,260,26900}, -- Design: Ruby Serpent
	[21950] = {14,275,26904}, -- Design: Cut Emerald - Deprecated
	[21951] = {14,275,26905}, -- Design: Cut Azerothian Diamond
	[21952] = {14,275,26906}, -- Design: Emerald Crown of Destruction
	[21953] = {14,285,26909}, -- Design: Emerald Owl
	[21954] = {14,285,26910}, -- Design: Ring of Bitter Shadows
	[21955] = {14,300,26912}, -- Design: Black Diamond Crab
	[21956] = {14,300,26914}, -- Design: Dark Iron Scorpid
	[21957] = {14,305,26915}, -- Design: Necklace of the Diamond Tower
	[21958] = {14,315,26918}, -- Design: Arcanite Sword Pendant
	[21959] = {14,325,26920}, -- Design: Blood Crown
	[21990] = {1,300,0}, -- Netherweave Bandage
	[21991] = {1,325,0}, -- Heavy Netherweave Bandage
	[21992] = {1,330,27032}, -- Manual: Netherweave Bandage
	[21993] = {1,360,27033}, -- Manual: Heavy Netherweave Bandage
	[22012] = {1,300,0}, -- Master First Aid - Doctor in the House
	[22462] = {10,350,0}, -- Runed Adamantite Rod
	[22463] = {10,375,0}, -- Runed Eternium Rod
	[22530] = {10,320,27906}, -- Formula: Enchant Bracer - Major Defense
	[22531] = {10,325,27911}, -- Formula: Enchant Bracer - Superior Healing
	[22532] = {10,335,27913}, -- Formula: Enchant Bracer - Restore Mana Prime
	[22533] = {10,350,27914}, -- Formula: Enchant Bracer - Fortitude
	[22534] = {10,360,27917}, -- Formula: Enchant Bracer - Spellpower
	[22535] = {10,360,27920}, -- Formula: Enchant Ring - Striking
	[22536] = {10,360,27924}, -- Formula: Enchant Ring - Spellpower
	[22537] = {10,370,27926}, -- Formula: Enchant Ring - Healing Power
	[22538] = {10,375,27927}, -- Formula: Enchant Ring - Stats
	[22539] = {10,325,27945}, -- Formula: Enchant Shield - Intellect
	[22540] = {10,340,27946}, -- Formula: Enchant Shield - Shield Block
	[22541] = {10,360,27947}, -- Formula: Enchant Shield - Resistance
	[22542] = {10,305,27948}, -- Formula: Enchant Boots - Vitality
	[22543] = {10,320,27950}, -- Formula: Enchant Boots - Fortitude
	[22544] = {10,340,27951}, -- Formula: Enchant Boots - Dexterity
	[22545] = {10,370,27954}, -- Formula: Enchant Boots - Surefooted
	[22546] = {10,325,27958}, -- Formula: Enchant Chest - Exceptional Mana
	[22547] = {10,345,27960}, -- Formula: Enchant Chest - Exceptional Stats
	[22548] = {10,330,27962}, -- Formula: Enchant Cloak - Major Resistance
	[22551] = {10,340,27968}, -- Formula: Enchant Weapon - Major Intellect
	[22552] = {10,340,27967}, -- Formula: Enchant Weapon - Major Striking
	[22553] = {10,350,27972}, -- Formula: Enchant Weapon - Potency
	[22554] = {10,350,27971}, -- Formula: Enchant 2H Weapon - Savagery
	[22555] = {10,350,27975}, -- Formula: Enchant Weapon - Major Spellpower
	[22556] = {10,360,27977}, -- Formula: Enchant 2H Weapon - Major Agility
	[22557] = {10,360,28004}, -- Formula: Enchant Weapon - Battlemaster
	[22558] = {10,360,28003}, -- Formula: Enchant Weapon - Spellsurge
	[22559] = {10,375,27984}, -- Formula: Enchant Weapon - Mongoose
	[22560] = {10,375,27981}, -- Formula: Enchant Weapon - Sunfire
	[22561] = {10,375,27982}, -- Formula: Enchant Weapon - Soulfrost
	[22562] = {10,310,28016}, -- Formula: Superior Mana Oil
	[22563] = {10,340,28019}, -- Formula: Superior Wizard Oil
	[22564] = {10,325,28021}, -- Formula: Arcane Dust
	[22565] = {10,335,28022}, -- Formula: Large Prismatic Shard
	[22647] = {6,60,28267}, -- Recipe: Crunchy Spider Surprise
	[22795] = {5,275,0}, -- Fel Blossom
	[22900] = {4,305,28543}, -- Recipe: Elixir of Camouflage
	[22901] = {4,315,28546}, -- Recipe: Sneaking Potion
	[22902] = {4,320,28549}, -- Recipe: Elixir of Major Frost Power
	[22903] = {4,320,28550}, -- Recipe: Insane Strength Potion
	[22904] = {4,325,28552}, -- Recipe: Elixir of the Searching Eye
	[22905] = {4,330,28553}, -- Recipe: Elixir of Major Agility
	[22906] = {4,335,28554}, -- Recipe: Shrouding Potion
	[22907] = {4,340,28555}, -- Recipe: Super Mana Potion
	[22908] = {4,345,28556}, -- Recipe: Elixir of Major Firepower
	[22909] = {4,345,28557}, -- Recipe: Elixir of Major Defense
	[22910] = {4,350,28558}, -- Recipe: Elixir of Major Shadow Power
	[22911] = {4,350,28562}, -- Recipe: Major Dreamless Sleep Potion
	[22912] = {4,350,28563}, -- Recipe: Heroic Potion
	[22913] = {4,350,28564}, -- Recipe: Haste Potion
	[22914] = {4,350,28565}, -- Recipe: Destruction Potion
	[22915] = {4,350,28566}, -- Recipe: Transmute Primal Air to Fire
	[22916] = {4,350,28567}, -- Recipe: Transmute Primal Earth to Water
	[22917] = {4,350,28568}, -- Recipe: Transmute Primal Fire to Earth
	[22918] = {4,350,28569}, -- Recipe: Transmute Primal Water to Air
	[22919] = {4,355,28570}, -- Recipe: Elixir of Major Mageblood
	[22920] = {4,360,28571}, -- Recipe: Major Fire Protection Potion
	[22921] = {4,360,28572}, -- Recipe: Major Frost Protection Potion
	[22922] = {4,360,28573}, -- Recipe: Major Nature Protection Potion
	[22923] = {4,360,28575}, -- Recipe: Major Arcane Protection Potion
	[22924] = {4,360,28576}, -- Recipe: Major Shadow Protection Potion
	[22925] = {4,360,28577}, -- Recipe: Major Holy Protection Potion
	[22926] = {4,365,28578}, -- Recipe: Elixir of Empowerment
	[22927] = {4,365,28579}, -- Recipe: Ironshield Potion
	[23130] = {14,300,28903}, -- Design: Teardrop Blood Garnet
	[23131] = {14,305,28905}, -- Design: Bold Blood Garnet
	[23133] = {14,315,28906}, -- Design: Runed Blood Garnet
	[23134] = {14,325,28907}, -- Design: Delicate Blood Garnet
	[23135] = {14,300,28910}, -- Design: Inscribed Flame Spessarite
	[23136] = {14,305,28912}, -- Design: Luminous Flame Spessarite
	[23137] = {14,315,28914}, -- Design: Glinting Flame Spessarite
	[23138] = {14,325,28915}, -- Design: Potent Flame Spessarite
	[23140] = {14,300,28916}, -- Design: Radiant Deep Peridot
	[23141] = {14,305,28917}, -- Design: Jagged Deep Peridot
	[23142] = {14,315,28918}, -- Design: Enduring Deep Peridot
	[23143] = {14,325,28924}, -- Design: Dazzling Deep Peridot
	[23144] = {14,300,28925}, -- Design: Glowing Shadow Draenite
	[23145] = {14,305,28927}, -- Design: Royal Shadow Draenite
	[23146] = {14,315,28933}, -- Design: Shifting Shadow Draenite
	[23147] = {14,325,28936}, -- Design: Sovereign Shadow Draenite
	[23148] = {14,300,28938}, -- Design: Brilliant Golden Draenite
	[23149] = {14,305,28944}, -- Design: Gleaming Golden Draenite
	[23150] = {14,315,28947}, -- Design: Thick Golden Draenite
	[23151] = {14,325,28948}, -- Design: Rigid Golden Draenite
	[23152] = {14,300,28950}, -- Design: Solid Azure Moonstone
	[23153] = {14,305,28953}, -- Design: Sparkling Azure Moonstone
	[23154] = {14,315,28955}, -- Design: Stormy Azure Moonstone
	[23155] = {14,325,28957}, -- Design: Lustrous Azure Moonstone
	[23424] = {14,275,0}, -- Fel Iron Ore
	[23425] = {14,325,0}, -- Adamantite Ore
	[23574] = {4,350,29688}, -- Recipe: Transmute Primal Might
	[23590] = {2,325,29566}, -- Plans: Adamantite Maul
	[23591] = {2,330,29568}, -- Plans: Adamantite Cleaver
	[23592] = {2,330,29569}, -- Plans: Adamantite Dagger
	[23593] = {2,335,29571}, -- Plans: Adamantite Rapier
	[23594] = {2,335,29603}, -- Plans: Adamantite Plate Bracers
	[23595] = {2,335,29605}, -- Plans: Adamantite Plate Gloves
	[23596] = {2,340,29606}, -- Plans: Adamantite Breastplate
	[23597] = {2,355,29608}, -- Plans: Enchanted Adamantite Belt
	[23598] = {2,355,29611}, -- Plans: Enchanted Adamantite Boots
	[23599] = {2,360,29610}, -- Plans: Enchanted Adamantite Breastplate
	[23600] = {2,365,29613}, -- Plans: Enchanted Adamantite Leggings
	[23601] = {2,350,29614}, -- Plans: Flamebane Bracers
	[23602] = {2,355,29615}, -- Plans: Flamebane Helm
	[23603] = {2,360,29616}, -- Plans: Flamebane Gloves
	[23604] = {2,365,29617}, -- Plans: Flamebane Breastplate
	[23605] = {2,360,29619}, -- Plans: Felsteel Gloves
	[23606] = {2,360,29620}, -- Plans: Felsteel Leggings
	[23607] = {2,365,29621}, -- Plans: Felsteel Helm
	[23608] = {2,360,29628}, -- Plans: Khorium Belt
	[23609] = {2,360,29629}, -- Plans: Khorium Pants
	[23610] = {2,365,29630}, -- Plans: Khorium Boots
	[23611] = {2,365,29642}, -- Plans: Ragesteel Gloves
	[23612] = {2,365,29643}, -- Plans: Ragesteel Helm
	[23613] = {2,370,29645}, -- Plans: Ragesteel Breastplate
	[23615] = {2,370,29648}, -- Plans: Swiftsteel Gloves
	[23617] = {2,370,29649}, -- Plans: Earthpeace Breastplate
	[23618] = {2,350,29656}, -- Plans: Adamantite Sharpening Stone
	[23619] = {2,360,29657}, -- Plans: Felsteel Shield Spike
	[23620] = {2,365,29658}, -- Plans: Felfury Gauntlets
	[23621] = {2,365,29622}, -- Plans: Gauntlets of the Iron Tower
	[23622] = {2,365,29662}, -- Plans: Steelgrip Gauntlets
	[23623] = {2,365,29663}, -- Plans: Storm Helm
	[23624] = {2,365,29664}, -- Plans: Helm of the Stalwart Defender
	[23625] = {2,365,29668}, -- Plans: Oathkeeper's Helm
	[23626] = {2,365,29669}, -- Plans: Black Felsteel Bracers
	[23627] = {2,365,29671}, -- Plans: Bracers of the Green Fortress
	[23628] = {2,365,29672}, -- Plans: Blessed Bracers
	[23629] = {2,365,29692}, -- Plans: Felsteel Longblade
	[23630] = {2,365,29693}, -- Plans: Khorium Champion
	[23631] = {2,365,29694}, -- Plans: Fel Edged Battleaxe
	[23632] = {2,365,29695}, -- Plans: Felsteel Reaper
	[23633] = {2,365,29696}, -- Plans: Runic Hammer
	[23634] = {2,365,29697}, -- Plans: Fel Hardened Maul
	[23635] = {2,365,29698}, -- Plans: Eternium Runed Blade
	[23636] = {2,365,29699}, -- Plans: Dirge
	[23637] = {2,365,29700}, -- Plans: Hand of Eternity
	[23638] = {2,340,29728}, -- Plans: Lesser Ward of Shielding
	[23639] = {2,375,29729}, -- Plans: Greater Ward of Shielding
	[23736] = {9,300,0}, -- Fel Iron Bomb
	[23737] = {9,325,0}, -- Adamantite Grenade
	[23758] = {9,340,0}, -- Cogspinner Goggles
	[23761] = {9,340,0}, -- Power Amplification Goggles
	[23762] = {9,350,0}, -- Ultra-Spectropic Detection Goggles
	[23763] = {9,360,0}, -- Hyper-Vision Goggles
	[23799] = {9,350,30313}, -- Schematic: Adamantite Rifle
	[23800] = {9,360,30314}, -- Schematic: Felsteel Boomstick
	[23802] = {9,375,30315}, -- Schematic: Ornate Khorium Rifle
	[23803] = {9,340,30316}, -- Schematic: Cogspinner Goggles
	[23804] = {9,340,30317}, -- Schematic: Power Amplification Goggles
	[23805] = {9,350,30318}, -- Schematic: Ultra-Spectropic Detection Goggles
	[23806] = {9,360,30325}, -- Schematic: Hyper-Vision Goggles
	[23807] = {9,335,30329}, -- Schematic: Adamantite Scope
	[23808] = {9,360,30332}, -- Schematic: Khorium Scope
	[23809] = {9,375,30334}, -- Schematic: Stabilized Eternium Scope
	[23810] = {9,325,30337}, -- Schematic: Crashin' Thrashin' Robot
	[23811] = {9,335,30341}, -- Schematic: White Smoke Flare
	[23812] = {9,335,30342}, -- Schematic: Red Smoke Flare
	[23813] = {9,335,30343}, -- Schematic: Blue Smoke Flare
	[23814] = {9,335,30344}, -- Schematic: Green Smoke Flare
	[23815] = {9,335,30347}, -- Schematic: Adamantite Shell Machine
	[23816] = {9,325,30348}, -- Schematic: Fel Iron Toolbox
	[23817] = {9,350,30349}, -- Schematic: Khorium Toolbox
	[23819] = {9,350,0}, -- Elemental Seaforium Charge
	[23820] = {9,325,0}, -- Critter Enlarger
	[23821] = {9,305,0}, -- Zapthrottle Mote Extractor
	[23824] = {9,330,0}, -- Rocket Boots Xtreme
	[23825] = {9,350,0}, -- Nigh Invulnerability Belt
	[23826] = {9,325,0}, -- The Bigger One
	[23827] = {9,340,0}, -- Super Sapper Charge
	[23828] = {9,375,0}, -- Gnomish Power Goggles
	[23829] = {9,375,0}, -- Gnomish Battle Goggles
	[23835] = {9,340,0}, -- Gnomish Poultryizer
	[23836] = {9,350,0}, -- Goblin Rocket Launcher
	[23838] = {9,350,0}, -- Foreman's Enchanted Helmet
	[23839] = {9,350,0}, -- Foreman's Reinforced Helmet
	[23840] = {9,335,0}, -- Remote Mail Terminal
	[23841] = {9,325,0}, -- Gnomish Flame Turret
	[23874] = {9,350,30547}, -- Schematic: Elemental Seaforium Charge
	[23882] = {9,325,30549}, -- Schematic: Critter Enlarger
	[23883] = {9,330,30551}, -- Schematic: Healing Potion Injector
	[23884] = {9,345,30552}, -- Schematic: Mana Potion Injector
	[23885] = {9,335,30555}, -- Schematic: Remote Mail Terminal
	[23887] = {9,355,30556}, -- Schematic: Rocket Boots Xtreme
	[23888] = {9,305,30548}, -- Schematic: Zapthrottle Mote Extractor
	[24000] = {10,325,27911}, -- Formula: Enchant Bracer - Superior Healing
	[24001] = {4,330,28553}, -- Recipe: Elixir of Major Agility
	[24002] = {2,360,29657}, -- Plans: Felsteel Shield Spike
	[24003] = {10,345,27960}, -- Formula: Enchant Chest - Exceptional Stats
	[24115] = {14,150,0}, -- TestProspectIronOre
	[24158] = {14,350,31053}, -- Design: Khorium Band of Shadows
	[24159] = {14,355,31054}, -- Design: Khorium Band of Frost
	[24160] = {14,355,31055}, -- Design: Khorium Inferno Band
	[24161] = {14,360,31056}, -- Design: Khorium Band of Leaves
	[24162] = {14,365,31057}, -- Design: Arcane Khorium Band
	[24163] = {14,345,31058}, -- Design: Heavy Felsteel Ring
	[24164] = {14,355,31060}, -- Design: Delicate Eternium Ring
	[24165] = {14,365,31061}, -- Design: Blazing Eternium Band
	[24166] = {14,355,31067}, -- Design: Thick Felsteel Necklace
	[24167] = {14,355,31068}, -- Design: Living Ruby Pendant
	[24168] = {14,360,31070}, -- Design: Braided Eternium Chain
	[24169] = {14,360,31071}, -- Design: Eye of the Night
	[24170] = {14,365,31072}, -- Design: Embrace of the Dawn
	[24171] = {14,365,31076}, -- Design: Chain of the Twilight Owl
	[24172] = {14,370,31077}, -- Design: Coronet of Verdant Flame
	[24173] = {14,370,31078}, -- Design: Circlet of Arcane Might
	[24174] = {14,360,31062}, -- Design: Pendant of Frozen Flame
	[24175] = {14,360,31063}, -- Design: Pendant of Thawing
	[24176] = {14,360,31064}, -- Design: Pendant of Withering
	[24177] = {14,360,31065}, -- Design: Pendant of Shadow's End
	[24178] = {14,360,31066}, -- Design: Pendant of the Null Rune
	[24179] = {14,370,31079}, -- Design: Felsteel Boar
	[24180] = {14,370,31080}, -- Design: Dawnstone Crab
	[24181] = {14,370,31081}, -- Design: Living Ruby Serpent
	[24182] = {14,370,31082}, -- Design: Talasite Owl
	[24183] = {14,370,31083}, -- Design: Nightseye Panther
	[24192] = {14,350,31089}, -- Design: Bright Living Ruby
	[24193] = {14,350,31084}, -- Design: Bold Living Ruby
	[24194] = {14,350,31085}, -- Design: Delicate Living Ruby
	[24195] = {14,350,31087}, -- Design: Teardrop Living Ruby
	[24196] = {14,350,31088}, -- Design: Runed Living Ruby
	[24197] = {14,350,31090}, -- Design: Subtle Living Ruby
	[24198] = {14,350,31091}, -- Design: Flashing Living Ruby
	[24199] = {14,350,31092}, -- Design: Solid Star of Elune
	[24200] = {14,350,31149}, -- Design: Sparkling Star of Elune
	[24201] = {14,350,31094}, -- Design: Lustrous Star of Elune
	[24202] = {14,350,31095}, -- Design: Stormy Star of Elune
	[24203] = {14,350,31096}, -- Design: Brilliant Dawnstone
	[24204] = {14,350,31097}, -- Design: Smooth Dawnstone
	[24205] = {14,350,31098}, -- Design: Rigid Dawnstone
	[24206] = {14,350,31099}, -- Design: Gleaming Dawnstone
	[24207] = {14,350,31100}, -- Design: Thick Dawnstone
	[24208] = {14,350,31101}, -- Design: Mystic Dawnstone
	[24209] = {14,350,31102}, -- Design: Sovereign Nightseye
	[24210] = {14,350,31103}, -- Design: Shifting Nightseye
	[24211] = {14,350,31104}, -- Design: Glowing Nightseye
	[24212] = {14,350,31105}, -- Design: Royal Nightseye
	[24213] = {14,350,31106}, -- Design: Inscribed Noble Topaz
	[24214] = {14,350,31107}, -- Design: Potent Noble Topaz
	[24215] = {14,350,31108}, -- Design: Luminous Noble Topaz
	[24216] = {14,350,31109}, -- Design: Glinting Noble Topaz
	[24217] = {14,350,31110}, -- Design: Enduring Talasite
	[24218] = {14,350,31111}, -- Design: Radiant Talasite
	[24219] = {14,350,31112}, -- Design: Dazzling Talasite
	[24220] = {14,350,31113}, -- Design: Jagged Talasite
	[24268] = {8,300,0}, -- Netherweave Net
	[24269] = {8,325,0}, -- Heavy Netherweave Net
	[24292] = {8,335,31430}, -- Pattern: Mystic Spellthread
	[24293] = {8,335,31431}, -- Pattern: Silver Spellthread
	[24294] = {8,375,31432}, -- Pattern: Runic Spellthread
	[24295] = {8,375,31433}, -- Pattern: Golden Spellthread
	[24296] = {8,350,31434}, -- Pattern: Unyielding Bracers
	[24297] = {8,350,31435}, -- Pattern: Bracers of Havok
	[24298] = {8,350,31437}, -- Pattern: Blackstrike Bracers
	[24299] = {8,350,31438}, -- Pattern: Cloak of the Black Void
	[24300] = {8,350,31440}, -- Pattern: Cloak of Eternity
	[24301] = {8,350,31441}, -- Pattern: White Remedy Cape
	[24302] = {8,365,31442}, -- Pattern: Unyielding Girdle
	[24303] = {8,365,31443}, -- Pattern: Girdle of Ruination
	[24304] = {8,365,31444}, -- Pattern: Black Belt of Knowledge
	[24305] = {8,365,31448}, -- Pattern: Resolute Cape
	[24306] = {8,365,31449}, -- Pattern: Vengeance Wrap
	[24307] = {8,365,31450}, -- Pattern: Manaweave Cloak
	[24308] = {8,375,31451}, -- Pattern: Whitemend Pants
	[24309] = {8,375,31452}, -- Pattern: Spellstrike Pants
	[24310] = {8,375,31453}, -- Pattern: Battlecast Pants
	[24311] = {8,375,31454}, -- Pattern: Whitemend Hood
	[24312] = {8,375,31455}, -- Pattern: Spellstrike Hood
	[24313] = {8,375,31456}, -- Pattern: Battlecast Hood
	[24314] = {8,340,31459}, -- Pattern: Bag of Jewels
	[24315] = {8,325,31461}, -- Pattern: Heavy Netherweave Net
	[24316] = {8,350,31373}, -- Pattern: Spellcloth
	[25526] = {2,350,32285}, -- Plans: Greater Rune of Warding
	[25720] = {3,325,32455}, -- Pattern: Heavy Knothide Leather
	[25721] = {3,325,32457}, -- Pattern: Vindicator's Armor Kit
	[25722] = {3,325,32458}, -- Pattern: Magister's Armor Kit
	[25725] = {3,350,32461}, -- Pattern: Riding Crop
	[25726] = {3,300,32482}, -- Pattern: Comfortable Insoles
	[25728] = {3,350,32485}, -- Pattern: Stylin' Purple Hat
	[25729] = {3,350,32487}, -- Pattern: Stylin' Adventure Hat
	[25730] = {3,350,32489}, -- Pattern: Stylin' Jungle Hat
	[25731] = {3,350,32488}, -- Pattern: Stylin' Crimson Hat
	[25732] = {3,340,32490}, -- Pattern: Fel Leather Gloves
	[25733] = {3,350,32493}, -- Pattern: Fel Leather Boots
	[25734] = {3,350,32494}, -- Pattern: Fel Leather Leggings
	[25735] = {3,360,32495}, -- Pattern: Heavy Clefthoof Vest
	[25736] = {3,355,32496}, -- Pattern: Heavy Clefthoof Leggings
	[25737] = {3,355,32497}, -- Pattern: Heavy Clefthoof Boots
	[25738] = {3,350,32498}, -- Pattern: Felstalker Belt
	[25739] = {3,360,32499}, -- Pattern: Felstalker Bracers
	[25740] = {3,360,32500}, -- Pattern: Felstalker Breastplate
	[25741] = {3,340,32501}, -- Pattern: Netherfury Belt
	[25742] = {3,340,32502}, -- Pattern: Netherfury Leggings
	[25743] = {3,350,32503}, -- Pattern: Netherfury Boots
	[25846] = {2,350,32656}, -- Plans: Adamantite Rod
	[25847] = {2,375,32657}, -- Plans: Eternium Rod
	[25848] = {10,350,32665}, -- Formula: Runed Adamantite Rod
	[25849] = {10,375,32667}, -- Formula: Runed Eternium Rod
	[25869] = {4,350,32765}, -- Recipe: Transmute Earthstorm Diamond
	[25870] = {4,350,32766}, -- Recipe: Transmute Skyfire Diamond
	[25887] = {9,335,32814}, -- Schematic: Purple Smoke Flare
	[25888] = {14,300,32810}, -- Design: Primal Stone Statue
	[25902] = {14,365,32866}, -- Design: Powerful Earthstorm Diamond
	[25903] = {14,365,32867}, -- Design: Bracing Earthstorm Diamond
	[25904] = {14,365,32870}, -- Design: Insightful Earthstorm Diamond
	[25905] = {14,365,32868}, -- Design: Tenacious Earthstorm Diamond
	[25906] = {14,365,32869}, -- Design: Brutal Earthstorm Diamond
	[25907] = {14,365,32871}, -- Design: Destructive Skyfire Diamond
	[25908] = {14,365,32873}, -- Design: Swift Skyfire Diamond
	[25909] = {14,365,32872}, -- Design: Mystical Skyfire Diamond
	[25910] = {14,365,32874}, -- Design: Enigmatic Skyfire Diamond
	[25978] = {11,200,0}, -- Seth's Graphite Fishing Pole
	[27532] = {11,275,0}, -- Master Fishing - The Art of Angling
	[27684] = {6,300,33279}, -- Recipe: Buzzard Bites
	[27685] = {6,1,33276}, -- Recipe: Lynx Steak
	[27686] = {6,1,33277}, -- Recipe: Roasted Moongraze Tenderloin
	[27687] = {6,50,33278}, -- Recipe: Bat Bites
	[27688] = {6,300,33284}, -- Recipe: Ravager Dog
	[27689] = {6,310,33285}, -- Recipe: Sporeling Snack
	[27690] = {6,315,33286}, -- Recipe: Blackened Basilisk
	[27691] = {6,325,33287}, -- Recipe: Roasted Clefthoof
	[27692] = {6,325,33288}, -- Recipe: Warp Burger
	[27693] = {6,325,33289}, -- Recipe: Talbuk Steak
	[27694] = {6,300,33290}, -- Recipe: Blackened Trout
	[27695] = {6,300,33291}, -- Recipe: Feltail Delight
	[27696] = {6,310,33292}, -- Recipe: Blackened Sporefish
	[27697] = {6,320,33293}, -- Recipe: Grilled Mudfish
	[27698] = {6,320,33294}, -- Recipe: Poached Bluefish
	[27699] = {6,325,33295}, -- Recipe: Golden Fish Sticks
	[27700] = {6,350,33296}, -- Recipe: Spicy Crawdad
	[27736] = {6,300,0}, -- Master Cookbook
	[28270] = {10,345,33992}, -- Formula: Enchant Chest - Major Resilience
	[28271] = {10,360,33994}, -- Formula: Enchant Gloves - Spell Strike
	[28272] = {10,360,33997}, -- Formula: Enchant Gloves - Major Spellpower
	[28273] = {10,350,33999}, -- Formula: Enchant Gloves - Major Healing
	[28274] = {10,325,34003}, -- Formula: Enchant Cloak - Spell Penetration
	[28276] = {10,350,34005}, -- Formula: Enchant Cloak - Greater Arcane Resistance
	[28277] = {10,350,34006}, -- Formula: Enchant Cloak - Greater Shadow Resistance
	[28279] = {10,360,34007}, -- Formula: Enchant Boots - Cat's Swiftness
	[28280] = {10,360,34008}, -- Formula: Enchant Boots - Boar's Speed
	[28281] = {10,350,34010}, -- Formula: Enchant Weapon - Major Healing
	[28282] = {10,325,34009}, -- Formula: Enchant Shield - Major Stamina
	[28291] = {14,325,34069}, -- Design: Smooth Golden Draenite
	[28596] = {14,305,34590}, -- Design: Bright Blood Garnet
	[28632] = {2,350,34608}, -- Plans: Adamantite Weightstone
	[29120] = {8,300,18456}, -- Pattern: Truefaith Vestments
	[29213] = {3,350,32498}, -- Pattern: Felstalker Belt
	[29214] = {3,360,32499}, -- Pattern: Felstalker Bracers
	[29215] = {3,360,32500}, -- Pattern: Felstalker Breastplate
	[29217] = {3,340,32501}, -- Pattern: Netherfury Belt
	[29218] = {3,350,32503}, -- Pattern: Netherfury Boots
	[29219] = {3,340,32502}, -- Pattern: Netherfury Leggings
	[29232] = {4,350,32766}, -- Recipe: Transmute Skyfire Diamond
	[29528] = {3,325,0}, -- Drums of War
	[29529] = {3,350,0}, -- Drums of Battle
	[29530] = {3,340,0}, -- Drums of Speed
	[29531] = {3,350,0}, -- Drums of Restoration
	[29532] = {3,350,0}, -- Drums of Panic
	[29664] = {3,325,35530}, -- Pattern: Reinforced Mining Bag
	[29669] = {3,340,35520}, -- Pattern: Shadow Armor Kit
	[29672] = {3,340,35521}, -- Pattern: Flame Armor Kit
	[29673] = {3,340,35522}, -- Pattern: Frost Armor Kit
	[29674] = {3,340,35523}, -- Pattern: Nature Armor Kit
	[29675] = {3,340,35524}, -- Pattern: Arcane Armor Kit
	[29677] = {3,350,35525}, -- Pattern: Enchanted Felscale Leggings
	[29682] = {3,350,35526}, -- Pattern: Enchanted Felscale Gloves
	[29684] = {3,350,35527}, -- Pattern: Enchanted Felscale Boots
	[29689] = {3,350,35529}, -- Pattern: Flamescale Leggings
	[29691] = {3,350,35528}, -- Pattern: Flamescale Boots
	[29693] = {3,350,35531}, -- Pattern: Flamescale Belt
	[29698] = {3,350,35532}, -- Pattern: Enchanted Clefthoof Leggings
	[29700] = {3,350,35533}, -- Pattern: Enchanted Clefthoof Gloves
	[29701] = {3,350,35534}, -- Pattern: Enchanted Clefthoof Boots
	[29702] = {3,350,35535}, -- Pattern: Blastguard Pants
	[29703] = {3,350,35536}, -- Pattern: Blastguard Boots
	[29704] = {3,350,35537}, -- Pattern: Blastguard Belt
	[29713] = {3,370,35538}, -- Pattern: Drums of Panic
	[29714] = {3,350,35539}, -- Pattern: Drums of Restoration
	[29717] = {3,365,35543}, -- Pattern: Drums of Battle
	[29718] = {3,345,35544}, -- Pattern: Drums of Speed
	[29719] = {3,335,35549}, -- Pattern: Cobrahide Leg Armor
	[29720] = {3,335,35555}, -- Pattern: Clefthide Leg Armor
	[29721] = {3,365,35557}, -- Pattern: Nethercleft Leg Armor
	[29722] = {3,365,35554}, -- Pattern: Nethercobra Leg Armor
	[29723] = {3,365,35558}, -- Pattern: Cobrascale Hood
	[29724] = {3,365,35559}, -- Pattern: Cobrascale Gloves
	[29725] = {3,365,35560}, -- Pattern: Windscale Hood
	[29726] = {3,365,35561}, -- Pattern: Hood of Primal Life
	[29727] = {3,365,35562}, -- Pattern: Gloves of the Living Touch
	[29728] = {3,365,35563}, -- Pattern: Windslayer Wraps
	[29729] = {3,365,35564}, -- Pattern: Living Dragonscale Helm
	[29730] = {3,365,35567}, -- Pattern: Earthen Netherscale Boots
	[29731] = {3,365,35568}, -- Pattern: Windstrike Gloves
	[29732] = {3,365,35572}, -- Pattern: Netherdrake Helm
	[29733] = {3,365,35573}, -- Pattern: Netherdrake Gloves
	[29734] = {3,365,35574}, -- Pattern: Thick Netherscale Breastplate
	[30156] = {6,300,36210}, -- Recipe: Clam Bar
	[30280] = {8,375,36315}, -- Pattern: Belt of Blasting
	[30281] = {8,375,36316}, -- Pattern: Belt of the Long Road
	[30282] = {8,375,36317}, -- Pattern: Boots of Blasting
	[30283] = {8,375,36318}, -- Pattern: Boots of the Long Road
	[30301] = {3,375,36349}, -- Pattern: Belt of Natural Power
	[30302] = {3,375,36351}, -- Pattern: Belt of Deep Shadow
	[30303] = {3,375,36352}, -- Pattern: Belt of the Black Eagle
	[30304] = {3,375,36353}, -- Pattern: Monsoon Belt
	[30305] = {3,375,36355}, -- Pattern: Boots of Natural Grace
	[30306] = {3,375,36357}, -- Pattern: Boots of Utter Darkness
	[30307] = {3,375,36358}, -- Pattern: Boots of the Crimson Hawk
	[30308] = {3,375,36359}, -- Pattern: Hurricane Boots
	[30321] = {2,375,36389}, -- Plans: Belt of the Guardian
	[30322] = {2,375,36390}, -- Plans: Red Belt of Battle
	[30323] = {2,375,36391}, -- Plans: Boots of the Protector
	[30324] = {2,375,36392}, -- Plans: Red Havoc Boots
	[30443] = {4,350,28568}, -- Recipe: Transmute Primal Fire to Earth
	[30444] = {3,325,35530}, -- Pattern: Reinforced Mining Bag
	[30469] = {8,355,36665}, -- Pattern: Netherflame Robe
	[30470] = {8,355,36667}, -- Pattern: Netherflame Belt
	[30471] = {8,355,36668}, -- Pattern: Netherflame Boots
	[30472] = {8,355,36669}, -- Pattern: Lifeblood Leggings
	[30473] = {8,355,36670}, -- Pattern: Lifeblood Belt
	[30474] = {8,355,36672}, -- Pattern: Lifeblood Bracers
	[30483] = {8,350,36686}, -- Pattern: Shadowcloth
	[30542] = {9,350,0}, -- Dimensional Ripper - Area 52
	[30544] = {9,350,0}, -- Ultrasafe Transporter: Toshley's Station
	[30826] = {14,360,37855}, -- Design: Ring of Arcane Shielding
	[30833] = {8,350,37873}, -- Pattern: Cloak of Arcane Evasion
	[30842] = {8,350,37882}, -- Pattern: Flameheart Bracers
	[30843] = {8,360,37883}, -- Pattern: Flameheart Gloves
	[30844] = {8,370,37884}, -- Pattern: Flameheart Vest
	[31354] = {4,300,17635}, -- Recipe: Flask of the Titans
	[31355] = {4,300,17637}, -- Recipe: Flask of Supreme Power
	[31356] = {4,300,17636}, -- Recipe: Flask of Distilled Wisdom
	[31357] = {4,300,17638}, -- Recipe: Flask of Chromatic Resistance
	[31358] = {14,370,31080}, -- Design: Dawnstone Crab
	[31359] = {14,315,28918}, -- Design: Enduring Deep Peridot
	[31361] = {3,335,35549}, -- Pattern: Cobrahide Leg Armor
	[31362] = {3,365,35554}, -- Pattern: Nethercobra Leg Armor
	[31390] = {2,375,38473}, -- Plans: Wildguard Breastplate
	[31391] = {2,375,38475}, -- Plans: Wildguard Leggings
	[31392] = {2,375,38476}, -- Plans: Wildguard Helm
	[31393] = {2,375,38477}, -- Plans: Iceguard Breastplate
	[31394] = {2,375,38478}, -- Plans: Iceguard Leggings
	[31395] = {2,375,38479}, -- Plans: Iceguard Helm
	[31401] = {14,375,38503}, -- Design: The Frozen Eye
	[31402] = {14,375,38504}, -- Design: The Natural Ward
	[31674] = {6,335,38868}, -- Recipe: Crunchy Serpent
	[31675] = {6,335,38867}, -- Recipe: Mok'Nathal Shortribs
	[31680] = {4,335,38960}, -- Recipe: Fel Strength Elixir
	[31681] = {4,345,38962}, -- Recipe: Fel Regeneration Potion
	[31682] = {4,360,38961}, -- Recipe: Fel Mana Potion
	[31870] = {14,325,39451}, -- Design: Great Golden Draenite
	[31871] = {14,325,39455}, -- Design: Balanced Shadow Draenite
	[31872] = {14,325,39458}, -- Design: Infused Shadow Draenite
	[31873] = {14,325,39466}, -- Design: Veiled Flame Spessarite
	[31874] = {14,325,39467}, -- Design: Wicked Flame Spessarite
	[31875] = {14,350,39452}, -- Design: Great Dawnstone
	[31876] = {14,350,39463}, -- Design: Balanced Nightseye
	[31877] = {14,350,39462}, -- Design: Infused Nightseye
	[31878] = {14,350,39470}, -- Design: Veiled Noble Topaz
	[31879] = {14,350,39471}, -- Design: Wicked Noble Topaz
	[32070] = {4,320,39637}, -- Recipe: Earthen Elixir
	[32071] = {4,330,39639}, -- Recipe: Elixir of Ironskin
	[32274] = {14,375,39705}, -- Design: Bold Crimson Spinel
	[32277] = {14,375,39706}, -- Design: Delicate Crimson Spinel
	[32281] = {14,375,39710}, -- Design: Teardrop Crimson Spinel
	[32282] = {14,375,39711}, -- Design: Runed Crimson Spinel
	[32283] = {14,375,39712}, -- Design: Bright Crimson Spinel
	[32284] = {14,375,39713}, -- Design: Subtle Crimson Spinel
	[32285] = {14,375,39714}, -- Design: Flashing Crimson Spinel
	[32286] = {14,375,39715}, -- Design: Solid Empyrean Sapphire
	[32287] = {14,375,39716}, -- Design: Sparkling Empyrean Sapphire
	[32288] = {14,375,39717}, -- Design: Lustrous Empyrean Sapphire
	[32289] = {14,375,39718}, -- Design: Stormy Empyrean Sapphire
	[32290] = {14,375,39719}, -- Design: Brilliant Lionseye
	[32291] = {14,375,39720}, -- Design: Smooth Lionseye
	[32292] = {14,375,39721}, -- Design: Rigid Lionseye
	[32293] = {14,375,39722}, -- Design: Gleaming Lionseye
	[32294] = {14,375,39723}, -- Design: Thick Lionseye
	[32295] = {14,375,39724}, -- Design: Mystic Lionseye
	[32296] = {14,375,39725}, -- Design: Great Lionseye
	[32297] = {14,375,39727}, -- Design: Sovereign Shadowsong Amethyst
	[32298] = {14,375,39728}, -- Design: Shifting Shadowsong Amethyst
	[32299] = {14,375,39729}, -- Design: Balanced Shadowsong Amethyst
	[32300] = {14,375,39730}, -- Design: Infused Shadowsong Amethyst
	[32301] = {14,375,39731}, -- Design: Glowing Shadowsong Amethyst
	[32302] = {14,375,39732}, -- Design: Royal Shadowsong Amethyst
	[32303] = {14,375,39733}, -- Design: Inscribed Pyrestone
	[32304] = {14,375,39734}, -- Design: Potent Pyrestone
	[32305] = {14,375,39735}, -- Design: Luminous Pyrestone
	[32306] = {14,375,39736}, -- Design: Glinting Pyrestone
	[32307] = {14,375,39737}, -- Design: Veiled Pyrestone
	[32308] = {14,375,39738}, -- Design: Wicked Pyrestone
	[32309] = {14,375,39739}, -- Design: Enduring Seaspray Emerald
	[32310] = {14,375,39740}, -- Design: Radiant Seaspray Emerald
	[32311] = {14,375,39741}, -- Design: Dazzling Seaspray Emerald
	[32312] = {14,375,39742}, -- Design: Jagged Seaspray Emerald
	[32381] = {9,275,39895}, -- Schematic: Fused Wiring
	[32411] = {14,365,39963}, -- Design: Thundering Skyfire Diamond
	[32412] = {14,365,39961}, -- Design: Relentless Earthstorm Diamond
	[32413] = {9,325,0}, -- Frost Grenade
	[32429] = {3,375,39997}, -- Pattern: Boots of Shackled Souls
	[32430] = {3,375,40000}, -- Pattern: Bracers of Shackled Souls
	[32431] = {3,375,40001}, -- Pattern: Greaves of Shackled Souls
	[32432] = {3,375,40002}, -- Pattern: Waistguard of Shackled Souls
	[32433] = {3,375,40003}, -- Pattern: Redeemed Soul Moccasins
	[32434] = {3,375,40004}, -- Pattern: Redeemed Soul Wristguards
	[32435] = {3,375,40005}, -- Pattern: Redeemed Soul Legguards
	[32436] = {3,375,40006}, -- Pattern: Redeemed Soul Cinch
	[32437] = {8,375,40020}, -- Pattern: Soulguard Slippers
	[32438] = {8,375,40021}, -- Pattern: Soulguard Bracers
	[32439] = {8,375,40023}, -- Pattern: Soulguard Leggings
	[32440] = {8,375,40024}, -- Pattern: Soulguard Girdle
	[32441] = {2,375,40033}, -- Plans: Shadesteel Sabots
	[32442] = {2,375,40034}, -- Plans: Shadesteel Bracers
	[32443] = {2,375,40035}, -- Plans: Shadesteel Greaves
	[32444] = {2,375,40036}, -- Plans: Shadesteel Girdle
	[32447] = {8,375,40060}, -- Pattern: Night's End
	[32461] = {9,350,0}, -- Furious Gizmatic Goggles
	[32472] = {9,350,0}, -- Justicebringer 2000 Specs
	[32473] = {9,350,0}, -- Tankatronic Goggles
	[32474] = {9,350,0}, -- Surestrike Goggles v2.0
	[32475] = {9,350,0}, -- Living Replicator Specs
	[32476] = {9,350,0}, -- Gadgetstorm Goggles
	[32478] = {9,350,0}, -- Deathblow X11 Goggles
	[32479] = {9,350,0}, -- Wonderheal XT40 Shades
	[32480] = {9,350,0}, -- Magnified Moon Specs
	[32494] = {9,350,0}, -- Destruction Holo-gogs
	[32495] = {9,350,0}, -- Powerheal 4000 Lens
	[32736] = {2,375,41132}, -- Plans: Swiftsteel Bracers
	[32737] = {2,375,41133}, -- Plans: Swiftsteel Shoulders
	[32738] = {2,375,41134}, -- Plans: Dawnsteel Bracers
	[32739] = {2,375,41135}, -- Plans: Dawnsteel Shoulders
	[32744] = {3,375,41156}, -- Pattern: Bracers of Renewed Life
	[32745] = {3,375,41157}, -- Pattern: Shoulderpads of Renewed Life
	[32746] = {3,375,41158}, -- Pattern: Swiftstrike Bracers
	[32747] = {3,375,41160}, -- Pattern: Swiftstrike Shoulders
	[32748] = {3,375,41161}, -- Pattern: Bindings of Lightning Reflexes
	[32749] = {3,375,41162}, -- Pattern: Shoulders of Lightning Reflexes
	[32750] = {3,375,41163}, -- Pattern: Living Earth Bindings
	[32751] = {3,375,41164}, -- Pattern: Living Earth Shoulders
	[32752] = {8,375,41207}, -- Pattern: Swiftheal Wraps
	[32753] = {8,375,41208}, -- Pattern: Swiftheal Mantle
	[32754] = {8,375,41205}, -- Pattern: Bracers of Nimble Thought
	[32755] = {8,375,41206}, -- Pattern: Mantle of Nimble Thought
	[33124] = {3,360,42546}, -- Pattern: Cloak of Darkness
	[33148] = {10,300,25086}, -- Formula: Enchant Cloak - Dodge
	[33149] = {10,300,25083}, -- Formula: Enchant Cloak - Stealth
	[33150] = {10,300,25084}, -- Formula: Enchant Cloak - Subtlety
	[33151] = {10,300,25084}, -- Formula: Enchant Cloak - Subtlety
	[33152] = {10,300,25080}, -- Formula: Enchant Gloves - Superior Agility
	[33153] = {10,300,25072}, -- Formula: Enchant Gloves - Threat
	[33155] = {14,360,42588}, -- Design: Kailee's Rose
	[33156] = {14,360,42589}, -- Design: Crimson Sun
	[33157] = {14,360,42590}, -- Design: Falling Star
	[33158] = {14,360,42591}, -- Design: Stone of Blades
	[33159] = {14,360,42592}, -- Design: Blood of Amber
	[33160] = {14,360,42593}, -- Design: Facet of Eternity
	[33165] = {10,350,42620}, -- Formula: Enchant Weapon - Greater Agility
	[33174] = {2,365,42662}, -- Plans: Ragesteel Shoulders
	[33186] = {2,335,42688}, -- Plans: Adamantite Weapon Chain
	[33205] = {3,365,42731}, -- Pattern: Shadowprowler's Chestguard
	[33209] = {4,375,42736}, -- Recipe: Flask of Chromatic Wonder
	[33305] = {14,360,42558}, -- Design: Don Julio's Heart
	[33307] = {10,375,42974}, -- Formula: Enchant Weapon - Executioner
	[33622] = {14,365,39961}, -- Design: Relentless Earthstorm Diamond
	[33783] = {14,350,43493}, -- Design: Steady Talasite
	[33792] = {2,35,43549}, -- Plans: Heavy Copper Longsword
	[33804] = {9,335,43676}, -- Schematic: Adamantite Arrow Maker
	[33837] = {6,275,0}, -- Cooking Pot
	[33851] = {6,275,0}, -- Cooking Pot
	[33852] = {6,275,0}, -- Cooking Pot
	[33869] = {6,300,43761}, -- Recipe: Broiled Bloodfin
	[33870] = {6,325,43707}, -- Recipe: Skullfish Soup
	[33871] = {6,300,43758}, -- Recipe: Stormchops
	[33873] = {6,325,43765}, -- Recipe: Spicy Hot Talbuk
	[33875] = {6,300,43772}, -- Recipe: Kibler's Bits
	[33925] = {6,1,43779}, -- Recipe: Delicious Chocolate Cake
	[33954] = {2,365,43846}, -- Plans: Hammer of Righteous Might
	[34060] = {9,350,0}, -- Flying Machine Control
	[34061] = {9,375,0}, -- Turbo-Charged Flying Machine Control
	[34109] = {11,100,43308}, -- Weather-Beaten Journal
	[34113] = {9,325,0}, -- Field Repair Bot 110G
	[34114] = {9,360,44391}, -- Schematic: Field Repair Bot 110G
	[34172] = {3,345,35544}, -- Pattern: Drums of Speed
	[34173] = {3,345,35544}, -- Pattern: Drums of Speed
	[34174] = {3,350,35539}, -- Pattern: Drums of Restoration
	[34175] = {3,350,35539}, -- Pattern: Drums of Restoration
	[34200] = {3,350,44359}, -- Pattern: Quiver of a Thousand Feathers
	[34201] = {3,350,44768}, -- Pattern: Netherscale Ammo Pouch
	[34218] = {3,350,44768}, -- Pattern: Netherscale Ammo Pouch
	[34221] = {14,365,44794}, -- Design: Chaotic Skyfire Diamond
	[34261] = {8,250,44950}, -- Pattern: Green Winter Clothes
	[34262] = {3,285,44953}, -- Pattern: Winter Boots
	[34319] = {8,250,44958}, -- Pattern: Red Winter Clothes
	[34353] = {9,350,0}, -- Quad Deathblow X44 Goggles
	[34354] = {9,350,0}, -- Mayhem Projection Goggles
	[34355] = {9,350,0}, -- Lightning Etched Specs
	[34356] = {9,350,0}, -- Surestrike Goggles v3.0
	[34357] = {9,350,0}, -- Hard Khorium Goggles
	[34358] = {14,350,0}, -- Hard Khorium Choker
	[34359] = {14,350,0}, -- Pendant of Sunfire
	[34360] = {14,350,0}, -- Amulet of Flowing Life
	[34364] = {8,350,0}, -- Sunfire Robe
	[34365] = {8,350,0}, -- Robe of Eternal Light
	[34369] = {3,350,0}, -- Carapace of Sun and Shadow
	[34371] = {3,350,0}, -- Leather Chestguard of the Sun
	[34373] = {3,350,0}, -- Embrace of the Phoenix
	[34375] = {3,350,0}, -- Sun-Drenched Scale Chestguard
	[34377] = {2,350,0}, -- Hard Khorium Battleplate
	[34379] = {2,350,0}, -- Sunblessed Breastplate
	[34413] = {6,325,45022}, -- Recipe: Hot Apple Cider
	[34440] = {4,315,0}, -- Mad Alchemist's Potion
	[34481] = {4,325,45061}, -- Recipe: Mad Alchemist's Potion
	[34491] = {3,360,45117}, -- Pattern: Bag of Many Hides
	[34689] = {14,365,44794}, -- Design: Chaotic Skyfire Diamond
	[34834] = {6,100,45695}, -- Recipe: Captain Rumsey's Lager
	[34836] = {11,300,0}, -- Spun Truesilver Fishing Line
	[34847] = {9,350,0}, -- Annihilator Holo-Gogs
	[34861] = {11,100,0}, -- Sharpened Fish Hook
	[34872] = {10,375,45765}, -- Formula: Void Shatter
	[35181] = {9,350,0}, -- Powerheal 9000 Lens
	[35182] = {9,350,0}, -- Hyper-Magnified Moon Specs
	[35183] = {9,350,0}, -- Wonderheal XT68 Shades
	[35184] = {9,350,0}, -- Primal-Attuned Goggles
	[35185] = {9,350,0}, -- Justicebringer 3000 Specs
	[35186] = {9,375,46111}, -- Schematic: Annihilator Holo-Gogs
	[35187] = {9,375,46107}, -- Schematic: Justicebringer 3000 Specs
	[35189] = {9,375,46108}, -- Schematic: Powerheal 9000 Lens
	[35190] = {9,375,46109}, -- Schematic: Hyper-Magnified Moon Specs
	[35191] = {9,375,46106}, -- Schematic: Wonderheal XT68 Shades
	[35192] = {9,375,46110}, -- Schematic: Primal-Attuned Goggles
	[35193] = {9,375,46112}, -- Schematic: Lightning Etched Specs
	[35194] = {9,375,46113}, -- Schematic: Surestrike Goggles v3.0
	[35195] = {9,375,46114}, -- Schematic: Mayhem Projection Goggles
	[35196] = {9,375,46115}, -- Schematic: Hard Khorium Goggles
	[35197] = {9,375,46116}, -- Schematic: Quad Deathblow X44 Goggles
	[35198] = {14,365,46122}, -- Design: Loop of Forged Power
	[35199] = {14,365,46123}, -- Design: Ring of Flowing Life
	[35200] = {14,365,46124}, -- Design: Hard Khorium Band
	[35201] = {14,365,46125}, -- Design: Pendant of Sunfire
	[35202] = {14,365,46126}, -- Design: Amulet of Flowing Life
	[35203] = {14,365,46127}, -- Design: Hard Khorium Choker
	[35204] = {8,365,46128}, -- Pattern: Sunfire Handwraps
	[35205] = {8,365,46129}, -- Pattern: Hands of Eternal Light
	[35206] = {8,365,46130}, -- Pattern: Sunfire Robe
	[35207] = {8,365,46131}, -- Pattern: Robe of Eternal Light
	[35208] = {2,365,46140}, -- Plans: Sunblessed Gauntlets
	[35209] = {2,365,46141}, -- Plans: Hard Khorium Battlefists
	[35210] = {2,365,46142}, -- Plans: Sunblessed Breastplate
	[35211] = {2,365,46144}, -- Plans: Hard Khorium Battleplate
	[35212] = {3,365,46132}, -- Pattern: Leather Gauntlets of the Sun
	[35213] = {3,365,46133}, -- Pattern: Fletcher's Gloves of the Phoenix
	[35214] = {3,365,46134}, -- Pattern: Gloves of Immortal Dusk
	[35215] = {3,365,46135}, -- Pattern: Sun-Drenched Scale Gloves
	[35216] = {3,365,46136}, -- Pattern: Leather Chestguard of the Sun
	[35217] = {3,365,46137}, -- Pattern: Embrace of the Phoenix
	[35218] = {3,365,46138}, -- Pattern: Carapace of Sun and Shadow
	[35219] = {3,365,46139}, -- Pattern: Sun-Drenched Scale Chestguard
	[35238] = {14,375,39729}, -- Design: Balanced Shadowsong Amethyst
	[35239] = {14,375,39731}, -- Design: Glowing Shadowsong Amethyst
	[35240] = {14,375,39730}, -- Design: Infused Shadowsong Amethyst
	[35241] = {14,375,39732}, -- Design: Royal Shadowsong Amethyst
	[35242] = {14,375,39728}, -- Design: Shifting Shadowsong Amethyst
	[35243] = {14,375,39727}, -- Design: Sovereign Shadowsong Amethyst
	[35244] = {14,375,39705}, -- Design: Bold Crimson Spinel
	[35245] = {14,375,39712}, -- Design: Bright Crimson Spinel
	[35246] = {14,375,39706}, -- Design: Delicate Crimson Spinel
	[35247] = {14,375,39714}, -- Design: Flashing Crimson Spinel
	[35248] = {14,375,39711}, -- Design: Runed Crimson Spinel
	[35249] = {14,375,39713}, -- Design: Subtle Crimson Spinel
	[35250] = {14,375,39710}, -- Design: Teardrop Crimson Spinel
	[35251] = {14,375,39741}, -- Design: Dazzling Seaspray Emerald
	[35252] = {14,375,39739}, -- Design: Enduring Seaspray Emerald
	[35253] = {14,375,39742}, -- Design: Jagged Seaspray Emerald
	[35254] = {14,375,39740}, -- Design: Radiant Seaspray Emerald
	[35255] = {14,375,39719}, -- Design: Brilliant Lionseye
	[35256] = {14,375,39722}, -- Design: Gleaming Lionseye
	[35257] = {14,375,39725}, -- Design: Great Lionseye
	[35258] = {14,375,39724}, -- Design: Mystic Lionseye
	[35259] = {14,375,39721}, -- Design: Rigid Lionseye
	[35260] = {14,375,39720}, -- Design: Smooth Lionseye
	[35261] = {14,375,39723}, -- Design: Thick Lionseye
	[35262] = {14,375,39717}, -- Design: Lustrous Empyrean Sapphire
	[35263] = {14,375,39715}, -- Design: Solid Empyrean Sapphire
	[35264] = {14,375,39716}, -- Design: Sparkling Empyrean Sapphire
	[35265] = {14,375,39718}, -- Design: Stormy Empyrean Sapphire
	[35266] = {14,375,39736}, -- Design: Glinting Pyrestone
	[35267] = {14,375,39733}, -- Design: Inscribed Pyrestone
	[35268] = {14,375,39735}, -- Design: Luminous Pyrestone
	[35269] = {14,375,39734}, -- Design: Potent Pyrestone
	[35270] = {14,375,39737}, -- Design: Veiled Pyrestone
	[35271] = {14,375,39738}, -- Design: Wicked Pyrestone
	[35273] = {7,375,46353}, -- Study of Advanced Smelting
	[35294] = {4,365,28578}, -- Recipe: Elixir of Empowerment
	[35295] = {4,350,28564}, -- Recipe: Haste Potion
	[35296] = {2,335,42688}, -- Plans: Adamantite Weapon Chain
	[35297] = {10,360,34008}, -- Formula: Enchant Boots - Boar's Speed
	[35298] = {10,305,27948}, -- Formula: Enchant Boots - Vitality
	[35299] = {10,360,34007}, -- Formula: Enchant Boots - Cat's Swiftness
	[35300] = {3,365,35568}, -- Pattern: Windstrike Gloves
	[35301] = {3,365,35573}, -- Pattern: Netherdrake Gloves
	[35302] = {3,365,35559}, -- Pattern: Cobrascale Gloves
	[35303] = {3,365,35562}, -- Pattern: Gloves of the Living Touch
	[35304] = {14,350,31092}, -- Design: Solid Star of Elune
	[35305] = {14,350,31088}, -- Design: Runed Living Ruby
	[35306] = {14,350,31089}, -- Design: Bright Living Ruby
	[35307] = {14,350,31098}, -- Design: Rigid Dawnstone
	[35308] = {8,350,31434}, -- Pattern: Unyielding Bracers
	[35309] = {8,365,31442}, -- Pattern: Unyielding Girdle
	[35310] = {9,330,30551}, -- Schematic: Healing Potion Injector
	[35311] = {9,345,30552}, -- Schematic: Mana Potion Injector
	[35322] = {14,350,46403}, -- Design: Quick Dawnstone
	[35323] = {14,350,46404}, -- Design: Reckless Noble Topaz
	[35325] = {14,350,46405}, -- Design: Forceful Talasite
	[35485] = {9,350,0}, -- Goblin Rocket Launcher [PH]
	[35498] = {10,350,46578}, -- Formula: Enchant Weapon - Deathfrost
	[35500] = {10,360,46594}, -- Formula: Enchant Chest - Defense
	[35502] = {14,370,46597}, -- Design: Eternal Earthstorm Diamond
	[35505] = {14,370,46601}, -- Design: Ember Skyfire Diamond
	[35517] = {3,375,41161}, -- Pattern: Bindings of Lightning Reflexes
	[35518] = {8,375,41205}, -- Pattern: Bracers of Nimble Thought
	[35519] = {3,375,41156}, -- Pattern: Bracers of Renewed Life
	[35520] = {3,375,41163}, -- Pattern: Living Earth Bindings
	[35521] = {3,375,41164}, -- Pattern: Living Earth Shoulders
	[35522] = {8,375,41206}, -- Pattern: Mantle of Nimble Thought
	[35523] = {3,375,41157}, -- Pattern: Shoulderpads of Renewed Life
	[35524] = {3,375,41162}, -- Pattern: Shoulders of Lightning Reflexes
	[35525] = {8,375,41208}, -- Pattern: Swiftheal Mantle
	[35526] = {8,375,41207}, -- Pattern: Swiftheal Wraps
	[35527] = {3,375,41158}, -- Pattern: Swiftstrike Bracers
	[35528] = {3,375,41160}, -- Pattern: Swiftstrike Shoulders
	[35529] = {2,375,41134}, -- Plans: Dawnsteel Bracers
	[35530] = {2,375,41135}, -- Plans: Dawnsteel Shoulders
	[35531] = {2,375,41132}, -- Plans: Swiftsteel Bracers
	[35532] = {2,375,41133}, -- Plans: Swiftsteel Shoulders
	[35533] = {14,365,46126}, -- Design: Amulet of Flowing Life
	[35534] = {14,365,46124}, -- Design: Hard Khorium Band
	[35535] = {14,365,46127}, -- Design: Hard Khorium Choker
	[35536] = {14,365,46122}, -- Design: Loop of Forged Power
	[35537] = {14,365,46125}, -- Design: Pendant of Sunfire
	[35538] = {14,365,46123}, -- Design: Ring of Flowing Life
	[35539] = {3,365,46138}, -- Pattern: Carapace of Sun and Shadow
	[35540] = {3,365,46137}, -- Pattern: Embrace of the Phoenix
	[35541] = {3,365,46133}, -- Pattern: Fletcher's Gloves of the Phoenix
	[35542] = {3,365,46134}, -- Pattern: Gloves of Immortal Dusk
	[35544] = {8,365,46129}, -- Pattern: Hands of Eternal Light
	[35545] = {3,365,46136}, -- Pattern: Leather Chestguard of the Sun
	[35546] = {3,365,46132}, -- Pattern: Leather Gauntlets of the Sun
	[35548] = {8,365,46131}, -- Pattern: Robe of Eternal Light
	[35549] = {3,365,46139}, -- Pattern: Sun-Drenched Scale Chestguard
	[35550] = {3,365,46135}, -- Pattern: Sun-Drenched Scale Gloves
	[35551] = {8,365,46128}, -- Pattern: Sunfire Handwraps
	[35552] = {8,365,46130}, -- Pattern: Sunfire Robe
	[35553] = {2,365,46141}, -- Plans: Hard Khorium Battlefists
	[35554] = {2,365,46144}, -- Plans: Hard Khorium Battleplate
	[35555] = {2,365,46142}, -- Plans: Sunblessed Breastplate
	[35556] = {2,365,46140}, -- Plans: Sunblessed Gauntlets
	[35564] = {6,250,46684}, -- Recipe: Charred Bear Kabobs
	[35566] = {6,250,46688}, -- Recipe: Juicy Bear Burger
	[35581] = {9,330,0}, -- Rocket Boots Xtreme Lite
	[35582] = {9,355,46697}, -- Schematic: Rocket Boots Xtreme Lite
	[35695] = {14,375,46775}, -- Design: Figurine - Empyrean Tortoise
	[35696] = {14,375,46776}, -- Design: Figurine - Khorium Boar
	[35697] = {14,375,46777}, -- Design: Figurine - Crimson Serpent
	[35698] = {14,375,46778}, -- Design: Figurine - Shadowsong Panther
	[35699] = {14,375,46779}, -- Design: Figurine - Seaspray Albatross
	[35708] = {14,350,46803}, -- Design: Regal Nightseye
	[35748] = {4,350,0}, -- Guardian's Alchemist Stone
	[35749] = {4,350,0}, -- Sorcerer's Alchemist Stone
	[35750] = {4,350,0}, -- Redeemer's Alchemist Stone
	[35751] = {4,350,0}, -- Assassin's Alchemist Stone
	[35752] = {4,375,47046}, -- Recipe: Guardian's Alchemist Stone
	[35753] = {4,375,47048}, -- Recipe: Sorcerer's Alchemist Stone
	[35754] = {4,375,47049}, -- Recipe: Redeemer's Alchemist Stone
	[35755] = {4,375,47050}, -- Recipe: Assassin's Alchemist Stone
	[35756] = {10,375,47051}, -- Formula: Enchant Cloak - Steelweave
	[35762] = {14,375,47055}, -- Design: Reckless Pyrestone
	[35763] = {14,375,47056}, -- Design: Quick Lionseye
	[35764] = {14,375,47054}, -- Design: Steady Seaspray Emerald
	[35765] = {14,375,47053}, -- Design: Forceful Seaspray Emerald
	[35766] = {14,375,47054}, -- Design: Steady Seaspray Emerald
	[35767] = {14,375,47055}, -- Design: Reckless Pyrestone
	[35768] = {14,375,47056}, -- Design: Quick Lionseye
	[35769] = {14,375,47053}, -- Design: Forceful Seaspray Emerald
	[37504] = {14,375,48789}, -- Design: Purified Shadowsong Amethyst
	[37915] = {8,250,49677}, -- Pattern: Dress Shoes
	[38229] = {8,375,50194}, -- Pattern: Mycah's Botanical Bag
	[38327] = {8,250,50644}, -- Pattern: Haliscan Jacket
	[38328] = {8,245,50647}, -- Pattern: Haliscan Pantaloons
	[185848] = {3,375,0}, -- Greater Drums of Battle
	[185849] = {3,375,0}, -- Greater Drums of Panic
	[185850] = {3,375,0}, -- Greater Drums of Restoration
	[185851] = {3,375,0}, -- Greater Drums of Speed
	[185852] = {3,375,0}, -- Greater Drums of War
	[185922] = {3,375,351766}, -- Pattern: Greater Drums of War
	[185923] = {3,375,351768}, -- Pattern: Greater Drums of Speed
	[185924] = {3,375,351769}, -- Pattern: Greater Drums of Restoration
	[185925] = {3,375,351770}, -- Pattern: Greater Drums of Panic
	[185926] = {3,375,351771}, -- Pattern: Greater Drums of Battle
--@end-version-bcc@
}

RECIPE[21302] = { 13, 300, 25347 } -- Handbook of Deadly Poison V
local RECIPE_TO_SPELL = {}
for k,v in pairs(RECIPE) do
	RECIPE_TO_SPELL[v[3]] = k
end

-- maybe weak table?
local RecipeCache = {}

function Recipe.IsRecipe(itemID)
	return RECIPE[itemID or 0] and true or false
end

function Recipe.GetRecipeData(itemID)
	return RECIPE[itemID or 0] and RECIPE[itemID or 0] or nil
end

function Recipe.GetRecipeDataForExtraFrame(itemID)
	local recipe = Recipe.GetRecipeData(itemID)
	if not itemID then return end
	return Profession.GetDataForExtraFrame(recipe[3])
end

function Recipe.GetCreatedItemID(itemID)
	return RECIPE[itemID or 0] and RECIPE[itemID or 0][3] or nil
end

function Recipe.GetRecipeDescription(itemID)
	return ( itemID and RECIPE[itemID] ) and RECIPE_PROF_TEXT[RECIPE[itemID][1] or RECIPE_PROF_DEFAULT] or nil
end

function Recipe.GetRecipeDescriptionWithRank(itemID)
	return ( itemID and RECIPE[itemID] ) and ( Profession.GetSpellDescriptionWithRank(RECIPE[itemID][3]) or Recipe.GetRecipeDescription(itemID) ) or nil
end

function Recipe.GetRecipeProfession(itemID)
	return ( itemID and RECIPE[itemID] ) and RECIPE[itemID][1] or nil
end

function Recipe.GetRecipeForSpell(spellID)
	return RECIPE_TO_SPELL[spellID or 0]
end

function Recipe.GetRecipeSkillRankForSpell(spellID)
	return RECIPE_TO_SPELL[spellID or 0] and RECIPE[ RECIPE_TO_SPELL[spellID or 0][2] ] or nil
end